/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.mail.distribution;

import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.beans.ListeDiffusion;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.util.CollectorUtils;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.NatureDescriptionDto;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.NatureDto;
import com.neogls.prism.central.vaadin.view.admin.mail.dto.MailListDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MailDistributionConfigurationService {
    private final IBusinessService businessService;

    public List<MailListDto> getRecipientsLists() {
        return this.businessService.getListeDestinataireMails().stream().map(MailListDto::fromListeDestinataireMail).toList();
    }

    public Map<String, MailListDto> getDistributionLists() {
        ImmutableMap mailLists = Maps.uniqueIndex((Iterable)this.getRecipientsLists(), MailListDto::getId);
        return (Map)this.businessService.getListesDiffusions().stream().collect(CollectorUtils.toUnmodifiableMapNullableValues(ListeDiffusion::getChamp, listeDiffusion -> (MailListDto)mailLists.get((Object)listeDiffusion.getListe())));
    }

    public List<NatureDto> getEventDistributionLists() {
        ImmutableMap mailLists = Maps.uniqueIndex((Iterable)this.getRecipientsLists(), MailListDto::getId);
        Map natures = this.businessService.getNatures();
        Map descriptionsNatures = this.businessService.getDescriptionsNatureMap();
        Map mailConfig = this.businessService.getDesciptionDiffusionEvt();
        ArrayList<NatureDto> eventDistributionLists = new ArrayList<NatureDto>(natures.size());
        for (Nature nature : natures.values()) {
            List descriptions = (List)descriptionsNatures.get(nature.getCode());
            ArrayList<NatureDescriptionDto> descriptionsDto = new ArrayList<NatureDescriptionDto>(descriptions.size());
            for (DescriptionNature description : descriptions) {
                descriptionsDto.add(new NatureDescriptionDto(description.getCode(), description.getLibelle(), (MailListDto)mailLists.get(mailConfig.get(description.getCode()))));
            }
            eventDistributionLists.add(new NatureDto(nature.getCode(), nature.getLabel(), Collections.unmodifiableList(descriptionsDto)));
        }
        return Collections.unmodifiableList(eventDistributionLists);
    }

    public void save(Map<String, MailListDto> distributionLists, List<NatureDto> eventDistributionLists) {
        HashMap<String, Integer> diffusion = new HashMap<String, Integer>();
        Iterator<Map.Entry<String, MailListDto>> iterator = distributionLists.entrySet().iterator();
        while (iterator.hasNext()) {
            MailListDto value;
            Map.Entry<String, MailListDto> entry;
            diffusion.put(entry.getKey(), (value = (entry = iterator.next()).getValue()) != null ? Integer.valueOf(value.getId()) : null);
        }
        Map<String, Integer> evenements = eventDistributionLists.stream().map(NatureDto::getDescriptions).flatMap(Collection::stream).filter(description -> description.getMailList() != null).collect(Collectors.toMap(NatureDescriptionDto::getCode, description -> description.getMailList().getId()));
        this.businessService.updateMailConfiguration(diffusion, evenements);
    }

    @Generated
    public MailDistributionConfigurationService(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

