/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.fauchage.passes;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.fauchage.passes.FauchagePassesParCircuitAdminEditDialog;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@RolesAllowed(value={"ACTION_FAUCHAGE_ADMIN_PASSE"})
@Route(value="admin/fauchage_passes_circuit", layout=PrismLayout.class)
public class FauchagePassesParCircuitAdminView
extends AbstractAdminView<FauchageCircuitPasse> {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;

    protected void init() {
        List circuits = this.businessService.getListeCircuits();
        this.grid.addColumn((ValueProvider & Serializable)p -> {
            Circuit circuit = circuits.stream().filter(c -> c.getId().equals(String.valueOf(p.getIdCircuit()))).findFirst().orElse(null);
            return circuit != null ? circuit.getNom() : "";
        }).setHeader(this.getTranslation("admin.fauchage.passe.head.circuit", new Object[0]));
        this.grid.addColumn(FauchageCircuitPasse::getDelegation).setHeader(this.getTranslation("admin.fauchage.passe.head.delegation", new Object[0]));
        this.grid.addColumn(FauchageCircuitPasse::getCentre).setHeader(this.getTranslation("admin.fauchage.passe.head.centre", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)c -> this.getTypeLabel(c.getType())).setHeader(this.getTranslation("admin.fauchage.passe.head.type", new Object[0]));
    }

    protected Collection<FauchageCircuitPasse> refreshItems() {
        AuthenticatedUser currentUser = this.userPermissionService.getCurrentUser();
        List passes = this.businessService.rechercheFauchageCircuitPasse(currentUser.getDelegation() != null ? currentUser.getDelegation().getNom() : null, currentUser.getCentre() != null ? currentUser.getCentre().getNom() : null);
        return passes.stream().filter(e -> {
            if (currentUser.getCentre() != null && !currentUser.getCentre().getNom().equals("")) {
                return e.getCentre().equals(currentUser.getCentre());
            }
            if (currentUser.getDelegation() != null && !currentUser.getDelegation().getNom().equals("")) {
                return e.getDelegation().equals(currentUser.getDelegation());
            }
            return true;
        }).collect(Collectors.toSet());
    }

    protected void createItem(SaveEvent<FauchageCircuitPasse> saveEvent) {
        this.businessService.updateFauchageCircuitPasse((FauchageCircuitPasse)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<FauchageCircuitPasse> saveEvent) {
        this.businessService.updateFauchageCircuitPasse((FauchageCircuitPasse)saveEvent.getValue());
    }

    protected void deleteItem(FauchageCircuitPasse item) {
        throw new UnsupportedOperationException("A center cannot be deleted.");
    }

    protected AbstractAdminEditDialog<FauchageCircuitPasse> createEditDialog(FauchageCircuitPasse item) {
        return new FauchagePassesParCircuitAdminEditDialog(item, this.businessService);
    }

    protected boolean isDeletable(FauchageCircuitPasse item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.centre.title", new Object[0]);
    }

    private String getTypeLabel(int type) {
        List passeTypes = this.businessService.listeTypePasse();
        for (FauchagePasseType passeType : passeTypes) {
            if (passeType.getTypeId() != type) continue;
            return passeType.getLibelle();
        }
        return null;
    }

    @Generated
    public FauchagePassesParCircuitAdminView(IBusinessService businessService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
    }
}

