/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.fauchage.passes;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.List;

public class FauchagePassesParCircuitAdminEditDialog
extends AbstractAdminEditDialog<FauchageCircuitPasse> {
    private ComboBox<String> delegation = new ComboBox();
    private ComboBox<String> centre = new ComboBox();
    private ComboBox<String> circuit = new ComboBox();
    private DatePicker dateDebut = new DatePicker();
    private DatePicker dateFin = new DatePicker();
    private ComboBox<String> typePasse = new ComboBox();
    private TextField coefficient = new TextField();
    private final Binder<FauchageCircuitPasse> binder = new Binder();
    private List<FauchagePasseType> passeTypes;
    private List<Circuit> circuits;

    FauchagePassesParCircuitAdminEditDialog(FauchageCircuitPasse oldItem, IBusinessService service) {
        super((Object)oldItem);
        this.passeTypes = service.listeTypePasse();
        this.circuits = service.getListeCircuits();
        this.configureFields(service);
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
    }

    private void configureFields(IBusinessService businessService) {
        String nomCircuitSelectionne = ((Circuit)this.circuits.stream().filter(x -> x.getId().equals(String.valueOf(((FauchageCircuitPasse)this.oldItem).getIdCircuit()))).findFirst().orElse(null)).getNom();
        this.circuit.setItems((Object[])new String[]{nomCircuitSelectionne});
        this.circuit.setValue((Object)nomCircuitSelectionne);
        this.circuit.setEnabled(false);
        List delegations = businessService.getDelegations();
        this.delegation.setItems(delegations.stream().map(Delegation::getNom).toList());
        this.delegation.setEnabled(false);
        this.centre.setItems(delegations.stream().map(Delegation::getNom).toList());
        this.centre.setEnabled(false);
        this.typePasse.setItems(this.passeTypes.stream().map(FauchagePasseType::getLibelle).toList());
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.circuit, this.getTranslation("admin.fauchage.passe.head.circuit", new Object[0]));
        content.addFormItem((Component)this.delegation, this.getTranslation("admin.centre.delegation", new Object[0]));
        content.addFormItem((Component)this.centre, this.getTranslation("admin.centre.name", new Object[0]));
        content.addFormItem((Component)this.typePasse, this.getTranslation("admin.fauchage.passe.head.type", new Object[0]));
        this.add(new Component[]{content});
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.delegation).asRequired(this.getTranslation("admin.centre.error.delegation", new Object[0])).bind(FauchageCircuitPasse::getDelegation, FauchageCircuitPasse::setDelegation).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.centre).asRequired(this.getTranslation("admin.centre.error.nom", new Object[0])).bind(FauchageCircuitPasse::getCentre, FauchageCircuitPasse::setCentre).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.typePasse).bind((ValueProvider & Serializable)p -> this.getTypeLabel(p.getType()), (Setter & Serializable)(p, typePasseLibelle) -> p.setType(this.getTypeFromLabel(typePasseLibelle)));
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.fauchage.passe.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.fauchage.passe.edit", new Object[0]);
    }

    protected FauchageCircuitPasse getValue() throws ValidationException {
        FauchageCircuitPasse value = this.isEdition() ? (FauchageCircuitPasse)this.oldItem : new FauchageCircuitPasse();
        this.binder.writeBean((Object)value);
        return value;
    }

    private String getTypeLabel(int type) {
        for (FauchagePasseType passeType : this.passeTypes) {
            if (passeType.getTypeId() != type) continue;
            return passeType.getLibelle();
        }
        return null;
    }

    private int getTypeFromLabel(String label) {
        for (FauchagePasseType passeType : this.passeTypes) {
            if (!passeType.getLibelle().equals(label)) continue;
            return passeType.getTypeId();
        }
        return 0;
    }
}

