/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.fauchage.passes;

import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.fauchage.passes.FauchagePassesParCentreAdminEditDialog;
import com.vaadin.flow.data.converter.LocalDateToDateConverter;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import lombok.Generated;

@RolesAllowed(value={"ACTION_FAUCHAGE_ADMIN_PASSE_CENTRE"})
@Route(value="admin/fauchage_passes_centre", layout=PrismLayout.class)
public class FauchagePassesParCentreAdminView
extends AbstractAdminView<FauchagePasse> {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;

    protected void init() {
        this.grid.addColumn(FauchagePasse::getDelegation).setHeader(this.getTranslation("admin.fauchage.passe.head.delegation", new Object[0]));
        this.grid.addColumn(FauchagePasse::getCentre).setHeader(this.getTranslation("admin.fauchage.passe.head.centre", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)p -> this.getTypeLabel(p.getType())).setHeader(this.getTranslation("admin.fauchage.passe.head.type", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)p -> new LocalDateToDateConverter(ZoneId.systemDefault()).convertToPresentation(new Date(p.getPasseDebut()), null)).setHeader(this.getTranslation("admin.fauchage.passe.head.start", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)p -> new LocalDateToDateConverter(ZoneId.systemDefault()).convertToPresentation(new Date(p.getPasseFin()), null)).setHeader(this.getTranslation("admin.fauchage.passe.head.end", new Object[0]));
    }

    protected Collection<FauchagePasse> refreshItems() {
        AuthenticatedUser currentUser = this.userPermissionService.getCurrentUser();
        return this.businessService.rechercheFauchage("", "");
    }

    protected void createItem(SaveEvent<FauchagePasse> saveEvent) {
        this.businessService.creerFauchagePasse((FauchagePasse)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<FauchagePasse> saveEvent) {
        this.businessService.updateFauchagePasse((FauchagePasse)saveEvent.getValue());
    }

    protected void deleteItem(FauchagePasse item) {
        throw new UnsupportedOperationException("A center cannot be deleted.");
    }

    protected AbstractAdminEditDialog<FauchagePasse> createEditDialog(FauchagePasse item) {
        return new FauchagePassesParCentreAdminEditDialog(item, this.businessService, this.userPermissionService);
    }

    protected boolean isDeletable(FauchagePasse item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.centre.title", new Object[0]);
    }

    private String getTypeLabel(int type) {
        List passeTypes = this.businessService.listeTypePasse();
        for (FauchagePasseType passeType : passeTypes) {
            if (passeType.getTypeId() != type) continue;
            return passeType.getLibelle();
        }
        return null;
    }

    @Generated
    public FauchagePassesParCentreAdminView(IBusinessService businessService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
    }
}

