/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.fauchage.passes;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.LocalDateToDateConverter;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class FauchagePassesParCentreAdminEditDialog
extends AbstractAdminEditDialog<FauchagePasse> {
    private ComboBox<String> delegation = new ComboBox();
    private ComboBox<String> centre = new ComboBox();
    private DatePicker dateDebut = new DatePicker();
    private DatePicker dateFin = new DatePicker();
    private ComboBox<String> typePasse = new ComboBox();
    private TextField coefficient = new TextField();
    private final Binder<FauchagePasse> binder = new Binder();
    private List<FauchagePasseType> passeTypes;

    FauchagePassesParCentreAdminEditDialog(FauchagePasse oldItem, IBusinessService service, UserPermissionService userPermissionService) {
        super((Object)oldItem);
        this.passeTypes = service.listeTypePasse();
        this.configureFields(service, userPermissionService);
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
    }

    private void configureFields(IBusinessService businessService, UserPermissionService userPermissionService) {
        List delegations = businessService.getDelegations();
        this.delegation.setItems(delegations.stream().map(Delegation::getNom).toList());
        this.delegation.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            for (Delegation d : delegations) {
                if (!d.getNom().equals(event.getValue())) continue;
                this.centre.clear();
                this.centre.setItems(((ComboBox)event.getSource()).isEmpty() ? List.of() : d.getCentres().stream().map(Centre::getNom).toList());
                this.centre.setReadOnly(((ComboBox)event.getSource()).isEmpty());
            }
        });
        AuthenticatedUser currentUser = userPermissionService.getCurrentUser();
        if (currentUser.getDelegation() != null) {
            this.delegation.setReadOnly(true);
            this.delegation.setValue((Object)currentUser.getDelegation().getNom());
        }
        if (currentUser.getCentre() != null) {
            this.centre.setReadOnly(true);
            this.centre.setValue((Object)currentUser.getCentre().getNom());
        }
        List passeTypes = businessService.listeTypePasse();
        this.typePasse.setItems(passeTypes.stream().map(FauchagePasseType::getLibelle).toList());
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.delegation, this.getTranslation("admin.centre.delegation", new Object[0]));
        content.addFormItem((Component)this.centre, this.getTranslation("admin.centre.name", new Object[0]));
        content.addFormItem((Component)this.typePasse, this.getTranslation("admin.fauchage.passe.head.type", new Object[0]));
        content.addFormItem((Component)this.dateDebut, this.getTranslation("admin.fauchage.passe.head.start", new Object[0]));
        content.addFormItem((Component)this.dateFin, this.getTranslation("admin.fauchage.passe.head.end", new Object[0]));
        this.add(new Component[]{content});
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.delegation).bind(FauchagePasse::getDelegation, FauchagePasse::setDelegation).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.centre).bind(FauchagePasse::getCentre, FauchagePasse::setCentre).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.typePasse).bind((ValueProvider & Serializable)p -> this.getTypeLabel(p.getType()), (Setter & Serializable)(p, typePasseLibelle) -> p.setType(this.getTypeFromLabel(typePasseLibelle))).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.dateDebut).withConverter((Converter)new LocalDateToDateConverter()).bind((ValueProvider & Serializable)p -> new Date(p.getPasseDebut()), (Setter & Serializable)(p, d) -> p.setPasseDebut(d.getTime()));
        this.binder.forField((HasValue)this.dateFin).withConverter((Converter)new LocalDateToDateConverter()).bind((ValueProvider & Serializable)p -> new Date(p.getPasseFin()), (Setter & Serializable)(p, d) -> p.setPasseFin(d.getTime()));
    }

    private String getTypeLabel(int type) {
        for (FauchagePasseType passeType : this.passeTypes) {
            if (passeType.getTypeId() != type) continue;
            return passeType.getLibelle();
        }
        return null;
    }

    private int getTypeFromLabel(String label) {
        for (FauchagePasseType passeType : this.passeTypes) {
            if (!passeType.getLibelle().equals(label)) continue;
            return passeType.getTypeId();
        }
        return 0;
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.fauchage.passe.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.fauchage.passe.edit", new Object[0]);
    }

    protected FauchagePasse getValue() throws ValidationException {
        FauchagePasse value = this.isEdition() ? (FauchagePasse)this.oldItem : new FauchagePasse();
        this.binder.writeBean((Object)value);
        return value;
    }
}

