/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.delegation;

import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.delegation.DelegationAdminEditDialog;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_DELEGATION_CENTRE"})
@Route(value="admin/delegation", layout=PrismLayout.class)
public class DelegationAdminView
extends AbstractAdminView<Delegation> {
    private final IBusinessService businessService;

    protected void init() {
        this.grid.addColumn(Delegation::getNom).setHeader(this.getTranslation("admin.delegation.head.identifiant", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)delegation -> delegation.isArchive() ? this.getTranslation("admin.delegation.archive", new Object[0]) : null).setHeader(this.getTranslation("admin.delegation.head.archive", new Object[0]));
    }

    protected Collection<Delegation> refreshItems() {
        return this.businessService.getDelegations();
    }

    protected void createItem(SaveEvent<Delegation> saveEvent) {
        this.businessService.creerDelegation((Delegation)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<Delegation> saveEvent) {
        this.businessService.updateDelegation((Delegation)saveEvent.getValue());
    }

    protected void deleteItem(Delegation item) {
        throw new UnsupportedOperationException("A delegation cannot be deleted.");
    }

    protected AbstractAdminEditDialog<Delegation> createEditDialog(Delegation item) {
        return new DelegationAdminEditDialog(item);
    }

    protected boolean isDeletable(Delegation item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.delegation.title", new Object[0]);
    }

    @Generated
    public DelegationAdminView(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

