/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.delegation;

import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Delegation;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.List;

public class DelegationAdminEditDialog
extends AbstractAdminEditDialog<Delegation> {
    private final TextField name = new TextField();
    private final Checkbox archive = new Checkbox();
    private final NumberField west = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField south = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField east = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField north = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final Component boundsErrorMessage = new Div(this.getTranslation("admin.error.coord", new Object[0]));
    private final Binder<Delegation> binder = new Binder();
    private final Binder<Bounds> boundsBinder = new Binder();

    DelegationAdminEditDialog(Delegation oldItem) {
        super((Object)oldItem);
        this.configureFields();
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
        this.boundsBinder.readBean((Object)(oldItem != null ? oldItem.getBounds() : null));
    }

    private void configureFields() {
        this.west.setValueChangeMode(ValueChangeMode.LAZY);
        this.south.setValueChangeMode(ValueChangeMode.LAZY);
        this.east.setValueChangeMode(ValueChangeMode.LAZY);
        this.north.setValueChangeMode(ValueChangeMode.LAZY);
        this.boundsErrorMessage.addClassNames(new String[]{"text-error", "text-xs", "box-border"});
        this.boundsErrorMessage.getStyle().set("padding-left", "156px");
        this.boundsErrorMessage.setVisible(false);
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.name, this.getTranslation("admin.delegation.name", new Object[0]));
        content.addFormItem((Component)this.archive, this.getTranslation("admin.delegation.archive", new Object[0]));
        Span coordsLabel = new Span(this.getTranslation("admin.coord", new Object[0]));
        coordsLabel.addClassName("mt-l");
        content.add(new Component[]{coordsLabel});
        content.addFormItem((Component)this.west, this.getTranslation("admin.minx", new Object[0]));
        content.addFormItem((Component)this.south, this.getTranslation("admin.miny", new Object[0]));
        content.addFormItem((Component)this.east, this.getTranslation("admin.maxx", new Object[0]));
        content.addFormItem((Component)this.north, this.getTranslation("admin.maxy", new Object[0]));
        content.add(new Component[]{this.boundsErrorMessage});
        this.add(new Component[]{content});
    }

    private void updateBoundsErrorMessage() {
        this.boundsErrorMessage.setVisible(this.isBoundsInvalid());
    }

    private boolean isBoundsInvalid() {
        return (!this.west.isEmpty() || !this.south.isEmpty() || !this.east.isEmpty() || !this.north.isEmpty()) && (this.west.isEmpty() || this.south.isEmpty() || this.east.isEmpty() || this.north.isEmpty()) || this.west.isInvalid() || this.south.isInvalid() || this.east.isInvalid() || this.north.isInvalid();
    }

    private boolean validateBounds() {
        boolean invalid = this.isBoundsInvalid();
        this.boundsErrorMessage.setVisible(invalid);
        return !invalid;
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.name).asRequired(this.getTranslation("admin.delegation.error.nom", new Object[0])).bind(Delegation::getNom, Delegation::setNom).setReadOnly(this.isEdition());
        this.binder.bind((HasValue)this.archive, Delegation::isArchive, Delegation::setArchive);
        this.boundsBinder.bind((HasValue)this.west, Bounds::getMinx, Bounds::setMinx);
        this.boundsBinder.bind((HasValue)this.south, Bounds::getMiny, Bounds::setMiny);
        this.boundsBinder.bind((HasValue)this.east, Bounds::getMaxx, Bounds::setMaxx);
        this.boundsBinder.bind((HasValue)this.north, Bounds::getMaxy, Bounds::setMaxy);
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.delegation.title", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.delegation.title", new Object[0]);
    }

    private Bounds getBounds() throws ValidationException {
        if (!this.validateBounds()) {
            throw new CustomValidationException(this.getTranslation("admin.error.coord", new Object[0]));
        }
        if (this.west.isEmpty()) {
            return null;
        }
        Bounds bounds = new Bounds();
        this.boundsBinder.writeBean((Object)bounds);
        return bounds;
    }

    protected Delegation getValue() throws ValidationException {
        Bounds bounds = this.getBounds();
        Delegation value = this.isEdition() ? (Delegation)this.oldItem : new Delegation();
        this.binder.writeBean((Object)value);
        value.setBounds(bounds);
        return value;
    }
}

