/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.Table;
import com.neogls.prism.central.vaadin.view.admin.components.PossibleValuesGetter;
import com.neogls.prism.central.vaadin.view.admin.components.RestrictionView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.ValueProvider;
import gls.outils.GLS;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestrictionView
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestrictionView.class);
    private final ComposantBean editing;
    private final Collection<ComposantBean> allComponents;
    private final List<Profil> allProfiles;
    protected final MultiSelectComboBox<Profil> profils = new MultiSelectComboBox();
    protected final Checkbox gray = new Checkbox();
    protected final Table<Restriction> restrictions = new Table();
    protected final ComboBox<ComposantBean> composants = new ComboBox();
    protected final ComboBox<String> operator = new ComboBox();
    protected final MultiSelectComboBox<String> possibleValues = new MultiSelectComboBox();
    protected final Button addBtn;

    final String getValue() {
        StringBuffer buff = new StringBuffer();
        if (!this.profils.getSelectedItems().isEmpty()) {
            MapDescription map = MapDescription.fromMap(new HashMap<String, String>(Map.of("nom", "profil", "type", "profil", "valeur", GLS.getString(this.profils.getSelectedItems().stream().map(Profil::getName).toList(), (String)","))));
            if (!((Boolean)this.gray.getValue()).booleanValue()) {
                map.addValue("affichage=0");
            }
            buff.append(map.toString(";"));
        }
        this.restrictions.getItems().stream().forEach(r -> {
            if (!buff.isEmpty()) {
                buff.append(":");
            }
            MapDescription map = MapDescription.fromMap(Map.of("nom", r.composant.getNom(), "type", r.composant.getType(), "operateur", r.operator, "valeur", GLS.getString(List.copyOf(r.values), (String)",")));
            buff.append(map.toString(";"));
        });
        if (buff.isEmpty()) {
            return null;
        }
        return buff.toString();
    }

    final void setValue(String restriction) {
        Map<String, ComposantBean> mapComponents = this.allComponents.stream().collect(Collectors.toMap(ComposantBean::getNom, c -> c));
        log.debug("Restriction value : " + restriction);
        this.profils.setValue((Object[])new Profil[0]);
        this.gray.setValue((Object)false);
        this.restrictions.setItems(Arrays.asList(new Restriction[0]));
        if (restriction == null) {
            this.updateComposantCombo();
            return;
        }
        Arrays.stream(restriction.split(":")).forEach(s -> {
            MapDescription map = MapDescription.parse((String)s, (String)";");
            String nom = map.getString("nom", null);
            String valeur = map.getString("valeur", null);
            String operateur = map.getString("operateur", null);
            String type = map.getString("type", null);
            if (nom == null || valeur == null || type == null) {
                return;
            }
            HashSet<String> valeurs = new HashSet<String>(Arrays.asList(valeur.split(",")));
            if (type.equals("profil")) {
                String affichage = map.getString("affichage", "1");
                log.debug("Restriction profil : affichage=" + affichage + " valeurs=" + GLS.getListe(valeurs.iterator()));
                this.gray.setValue((Object)affichage.equals("1"));
                this.profils.setValue(this.allProfiles.stream().filter(p -> valeurs.contains(p.getName())).toList());
            } else {
                if (operateur == null) {
                    return;
                }
                ComposantBean composant = (ComposantBean)mapComponents.get(nom);
                if (composant == null) {
                    return;
                }
                this.restrictions.addItem((Object)new Restriction(composant, operateur, valeurs));
            }
        });
        this.updateComposantCombo();
    }

    private void updateComposantCombo() {
        this.composants.setItems(this.allComponents.stream().filter(c -> c != this.editing).filter(c -> this.restrictions.getItems().stream().filter(r -> r.composant == c).findAny().isEmpty()).filter(c -> !((Collection)c.getChamp().getView((IComposantFactory)PossibleValuesGetter.get())).isEmpty()).toList());
    }

    private void updatePossibleValueCombo() {
        this.composants.getOptionalValue().ifPresentOrElse(v -> {
            this.possibleValues.setItems((Collection)v.getChamp().getView((IComposantFactory)PossibleValuesGetter.get()));
            this.possibleValues.setEnabled(true);
        }, () -> {
            this.possibleValues.setItems((Object[])new String[0]);
            this.possibleValues.setEnabled(false);
        });
    }

    public RestrictionView(IBusinessService businessService, Collection<ComposantBean> allComponents, ComposantBean editing) {
        this.allComponents = allComponents;
        this.editing = editing;
        this.getStyle().setBorder("1px solid lightgray").setBorderRadius("5px").setPaddingTop("0.5em").setPaddingBottom("0").setMarginTop("1em");
        this.setSpacing(false);
        Span sectionTitle = new Span(this.getTranslation("admin.components.restrictions", new Object[0]));
        sectionTitle.getStyle().setMarginTop("0").setMarginBottom("0.5em");
        this.add(new Component[]{sectionTitle});
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        this.add(new Component[]{content});
        this.allProfiles = businessService.getProfils();
        this.profils.setItems((Collection)this.allProfiles);
        this.profils.setItemLabelGenerator(Profil::getName);
        this.profils.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.profils.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ve -> this.gray.setEnabled(!((Set)ve.getValue()).isEmpty()));
        content.addFormItem((Component)this.profils, this.getTranslation("admin.components.restrictions.profil", new Object[0]));
        content.addFormItem((Component)this.gray, this.getTranslation("admin.components.restrictions.gray", new Object[0]));
        this.restrictions.removeColumns();
        this.restrictions.addColumn("admin.components.restrictions.field", false, (ValueProvider & Serializable)r -> r.composant.getNom());
        this.restrictions.addColumn("admin.components.restrictions.operator", false, (ValueProvider & Serializable)r -> r.operator);
        this.restrictions.addColumn("admin.components.restrictions.values", false, (ValueProvider & Serializable)r -> GLS.getString(r.values.stream().collect(Collectors.toUnmodifiableList()), (String)";"));
        this.restrictions.addDeleteControls();
        this.restrictions.setSize(Table.TableSize.SMALL);
        FormLayout.FormItem formItem = content.addFormItem((Component)this.restrictions, this.getTranslation("admin.components.restrictions", new Object[0]));
        formItem.getStyle().setAlignItems(Style.AlignItems.CENTER);
        this.updateComposantCombo();
        this.composants.setItemLabelGenerator((ItemLabelGenerator & Serializable)c -> c.getNom());
        this.composants.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ce -> this.updatePossibleValueCombo());
        this.operator.setItems((Object[])new String[]{"egal", "different"});
        this.operator.setItemLabelGenerator((ItemLabelGenerator & Serializable)v -> this.getTranslation("admin.components.restrictions.operator." + v, new Object[0]));
        this.operator.setMaxWidth("5em");
        this.addBtn = new Button((Component)new Icon(VaadinIcon.PLUS));
        this.addBtn.setAriaLabel(this.getTranslation("admin.components.restrictions.add", new Object[0]));
        this.addBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ICON});
        this.addBtn.addClickListener((ComponentEventListener & Serializable)b -> {
            this.restrictions.addItem((Object)new Restriction((ComposantBean)this.composants.getValue(), (String)this.operator.getValue(), this.possibleValues.getValue()));
            this.composants.setValue(null);
            this.updateComposantCombo();
        });
        this.operator.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ce -> this.toggleAddButtonVisibility());
        this.possibleValues.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ce -> this.toggleAddButtonVisibility());
        HorizontalLayout line1 = new HorizontalLayout(new Component[]{this.composants, this.operator, this.possibleValues, this.addBtn});
        line1.setFlexGrow(1.0, new HasElement[]{this.composants, this.possibleValues});
        line1.setMargin(false);
        line1.setPadding(false);
        line1.setWidthFull();
        content.addFormItem((Component)line1, this.getTranslation("admin.components.restrictions.add", new Object[0]));
    }

    private void toggleAddButtonVisibility() {
        this.addBtn.setEnabled(this.operator.getValue() != null && !this.possibleValues.getSelectedItems().isEmpty());
    }
}

