/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.components.ComponentsAdminEditDialog;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import gls.outils.GLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_COMPOSANTS"})
@Route(value="admin/component", layout=PrismLayout.class)
public class ComponentsAdminView
extends AbstractAdminView<ComposantBean> {
    private final IBusinessService businessService;
    private String filterValue = "";

    protected void init() {
        this.grid.addColumn(ComposantBean::getNom).setHeader(this.getTranslation("admin.components.head.code", new Object[0])).setSortable(true);
        this.grid.addColumn(ComposantBean::getLibelle).setHeader(this.getTranslation("admin.components.head.libelle", new Object[0])).setSortable(true);
        this.grid.addColumn((ValueProvider & Serializable)it -> this.getTranslation("component.type." + it.getType(), new Object[0])).setHeader(this.getTranslation("admin.components.head.type", new Object[0])).setSortable(true);
    }

    protected Collection<ComposantBean> refreshItems() {
        return this.businessService.getListComposants(false).stream().filter(ComponentsAdminView::componentIsEditable).toList();
    }

    static boolean componentIsEditable(ComposantBean c) {
        if (c == null) {
            return false;
        }
        return GLS.estVide((String)c.getParent()) && (GLS.egal((String)c.getType(), (String)"GLSIntBox") || GLS.egal((String)c.getType(), (String)"GLSDecimalBox") || GLS.egal((String)c.getType(), (String)"GLSCheckBox") || GLS.egal((String)c.getType(), (String)"GLSMultiCheckBox") || GLS.egal((String)c.getType(), (String)"GLSComboBox") || GLS.egal((String)c.getType(), (String)"ComposantChoix") || GLS.egal((String)c.getType(), (String)"GLSTextBox") || GLS.egal((String)c.getType(), (String)"GLSCalendarBox") || GLS.egal((String)c.getType(), (String)"GLSRadioBox") || GLS.egal((String)c.getType(), (String)"GLSImageComboBox") || GLS.egal((String)c.getType(), (String)"GLSImageMultiple") || GLS.egal((String)c.getType(), (String)"ComposantVehiculesEnCause"));
    }

    protected void createItem(SaveEvent<ComposantBean> saveEvent) {
        this.businessService.creerComposantBean((ComposantBean)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<ComposantBean> saveEvent) {
        this.businessService.updateComposantBean((ComposantBean)saveEvent.getValue());
    }

    protected void deleteItem(ComposantBean item) {
        this.businessService.deleteComposant(item.getNom());
    }

    protected AbstractAdminEditDialog<ComposantBean> createEditDialog(ComposantBean item) {
        return new ComponentsAdminEditDialog(item, this.businessService, this.unfilteredItems);
    }

    protected boolean isDeletable(ComposantBean item) {
        return true;
    }

    protected boolean hasFilter() {
        return true;
    }

    protected void onFilterValueChange(String filterValue) {
        this.filterValue = filterValue.toLowerCase();
    }

    protected boolean filter(ComposantBean item) {
        return item.getNom().toLowerCase().contains(this.filterValue);
    }

    protected String getFilterPlaceholder() {
        return this.getTranslation("admin.components.search", new Object[0]);
    }

    public String getPageTitle() {
        return this.getTranslation("admin.components.title", new Object[0]);
    }

    @Generated
    public ComponentsAdminView(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

