/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.components.AbstractChampParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampChoixImageMultipleParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampChoixImageUniqueParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampChoixParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampComboboxParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampDateHeureParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampDecimalParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampEntierParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampMultiCheckboxParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampRadioButtonParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampVehiculesEnCauseParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.RestrictionView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationException;
import gls.outils.GLS;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentsAdminEditDialog
extends AbstractAdminEditDialog<ComposantBean> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentsAdminEditDialog.class);
    private static final String[] COMPONENT_TYPES = new String[]{"GLSIntBox", "GLSDecimalBox", "GLSCheckBox", "GLSMultiCheckBox", "GLSComboBox", "ComposantChoix", "GLSTextBox", "GLSCalendarBox", "GLSRadioBox", "GLSImageComboBox", "GLSImageMultiple", "ComposantVehiculesEnCause"};
    private final TextField name = new TextField();
    private final TextField libelle = new TextField();
    private final ComboBox<String> type = new ComboBox();
    private final Checkbox mandatory = new Checkbox();
    private final Map<String, AbstractChampParameterView<?>> champsParameterViews = Map.ofEntries(Map.entry("GLSIntBox", new ChampEntierParameterView()), Map.entry("GLSDecimalBox", new ChampDecimalParameterView()), Map.entry("GLSCalendarBox", new ChampDateHeureParameterView()), Map.entry("GLSMultiCheckBox", new ChampMultiCheckboxParameterView()), Map.entry("GLSComboBox", new ChampComboboxParameterView()), Map.entry("ComposantChoix", new ChampChoixParameterView()), Map.entry("GLSRadioBox", new ChampRadioButtonParameterView()), Map.entry("GLSImageComboBox", new ChampChoixImageUniqueParameterView()), Map.entry("GLSImageMultiple", new ChampChoixImageMultipleParameterView()), Map.entry("ComposantVehiculesEnCause", new ChampVehiculesEnCauseParameterView()));
    private final RestrictionView restriction;

    protected String getCreateTitle() {
        return this.getTranslation("admin.components.create", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.components.edit", new Object[0]);
    }

    public ComponentsAdminEditDialog(ComposantBean edited, IBusinessService businessService, Collection<ComposantBean> allComponents) {
        super((Object)edited);
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(50.0f, Unit.EM);
        this.add(new Component[]{content});
        this.type.setItems((Object[])COMPONENT_TYPES);
        this.type.setItemLabelGenerator((ItemLabelGenerator & Serializable)type -> this.getTranslation("component.type." + type, new Object[0]));
        this.type.addValueChangeListener((HasValue.ValueChangeListener & Serializable)comboBoxStringComponentValueChangeEvent -> this.updateChampParameterVisibility());
        content.addFormItem((Component)this.name, this.getTranslation("admin.components.code", new Object[0]));
        content.addFormItem((Component)this.libelle, this.getTranslation("admin.components.libelle", new Object[0]));
        content.addFormItem((Component)this.type, this.getTranslation("admin.components.type", new Object[0]));
        content.addFormItem((Component)this.mandatory, this.getTranslation("admin.components.mandatory", new Object[0]));
        this.champsParameterViews.forEach((k, v) -> content.add(new Component[]{v}));
        this.restriction = new RestrictionView(businessService, allComponents, edited);
        content.add(new Component[]{this.restriction});
        if (edited != null) {
            log.debug("Editing " + edited.getNom() + " of type " + edited.getType() + ". Definition=" + edited.getDefinition() + " Default=" + edited.getDefaut());
            this.name.setValue(edited.getNom());
            this.libelle.setValue(edited.getLibelle());
            this.type.setValue((Object)edited.getType());
            this.mandatory.setValue((Object)(Optional.ofNullable(edited.getStyle()).orElse(0) == 2 ? 1 : 0));
            this.restriction.setValue(edited.getRestrictions());
            Optional.ofNullable((AbstractChampParameterView)this.champsParameterViews.get(edited.getType())).ifPresent(v -> v.setValue(edited));
        }
        this.updateChampParameterVisibility();
    }

    private void updateChampParameterVisibility() {
        this.champsParameterViews.forEach((k, v) -> v.setVisible(k.equals(this.type.getValue())));
    }

    protected ComposantBean getValue() throws ValidationException {
        ComposantBean value = new ComposantBean();
        if (GLS.estVide((String)this.name.getValue())) {
            throw new CustomValidationException(this.getTranslation("admin.components.error.code", new Object[0]));
        }
        value.setNom(this.name.getValue());
        if (GLS.estVide((String)this.libelle.getValue())) {
            throw new CustomValidationException(this.getTranslation("admin.components.error.libelle", new Object[0]));
        }
        value.setLibelle(this.libelle.getValue());
        if (GLS.estVide((String)((String)this.type.getValue()))) {
            throw new CustomValidationException(this.getTranslation("admin.components.error.type", new Object[0]));
        }
        value.setType((String)this.type.getValue());
        value.setStyle(Integer.valueOf((Boolean)this.mandatory.getValue() != false ? 2 : 0));
        Optional.ofNullable((AbstractChampParameterView)this.champsParameterViews.get(this.type.getValue())).ifPresent(cpv -> cpv.updateComponent(value, ((Boolean)this.mandatory.getValue()).booleanValue()));
        value.setRestrictions(this.restriction.getValue());
        return value;
    }
}

