/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.neogls.prism.central.vaadin.common.component.Table;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.components.AbstractChampParameterView;
import com.neogls.prism.central.vaadin.view.admin.components.ChampParameterUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.function.ValueProvider;
import gls.outils.GLS;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChampWithPossibleValuesParameterView<T extends Champ>
extends AbstractChampParameterView<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampWithPossibleValuesParameterView.class);
    protected final ComboBox<ChampParameterUtils.PossibleValue> defaultValue = new ComboBox();
    protected final Table<ChampParameterUtils.PossibleValue> possibleValues = new Table();
    protected final ComboBox<ChampParameterUtils.PossibleValue> freeTextValue = new ComboBox();
    protected final FormLayout.FormItem defaultValueFormItem;

    ChampWithPossibleValuesParameterView() {
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        this.add(new Component[]{content});
        this.possibleValues.removeColumns();
        if (this.hasImage()) {
            this.possibleValues.addColumn("admin.components.possiblevalues.table.head.imagename", false, ChampParameterUtils.PossibleValue::getValue);
            this.possibleValues.addComponentColumn("admin.components.possiblevalues.table.head.image", false, (ValueProvider & Serializable)im -> ChampParameterUtils.createImg((String)im.getImage(), (String)"", (int)25, (int)25), true);
        } else {
            this.possibleValues.addColumn("admin.components.possiblevalues.table.head.value", false, ChampParameterUtils.PossibleValue::getValue);
        }
        this.possibleValues.addDeleteControls();
        this.possibleValues.setSize(Table.TableSize.SMALL);
        content.addFormItem((Component)this.possibleValues, this.getTranslation("admin.components.possiblevalues", new Object[0]));
        this.addNewPossibleValueToForm(content);
        if (this.hasFreeText()) {
            this.freeTextValue.setItemLabelGenerator(ChampParameterUtils.PossibleValue::getValue);
            content.addFormItem((Component)this.freeTextValue, this.getTranslation("admin.components.possiblevalues.freetextValue", new Object[0]));
        }
        this.defaultValue.setItemLabelGenerator(ChampParameterUtils.PossibleValue::getValue);
        this.defaultValueFormItem = content.addFormItem((Component)this.defaultValue, this.getTranslation("admin.components.default", new Object[0]));
    }

    protected abstract void addNewPossibleValueToForm(FormLayout var1);

    protected abstract boolean hasFreeText();

    protected abstract boolean hasImage();

    protected void addPossibleValue(ChampParameterUtils.PossibleValue value) {
        this.possibleValues.addItem((Object)value);
        this.defaultValue.setItems((Collection)this.possibleValues.getItems());
        if (this.hasFreeText()) {
            this.freeTextValue.setItems((Collection)this.possibleValues.getItems());
        }
    }

    protected void setPossibleValues(List<ChampParameterUtils.PossibleValue> values) {
        this.possibleValues.setItems(values);
        this.defaultValue.setItems(values);
        if (this.hasFreeText()) {
            this.freeTextValue.setItems(values);
        }
    }

    final void updateUi(T value, String defaultValue) {
        this.updateUiSpecific(value, defaultValue);
        if (defaultValue != null) {
            this.possibleValues.getItems().stream().filter(t -> defaultValue.equals(t.getValue())).findFirst().ifPresent(t -> this.defaultValue.setValue(t));
        }
        this.getFreeTextValue(value).ifPresent(t -> this.freeTextValue.setValue(t));
    }

    protected abstract Optional<ChampParameterUtils.PossibleValue> getFreeTextValue(T var1);

    abstract void updateUiSpecific(T var1, String var2);

    void updateComponent(ComposantBean component, boolean mandatory) {
        if (this.possibleValues.getItems().isEmpty()) {
            throw new CustomValidationException(this.getTranslation("admin.components.error.possiblevalue", new Object[0]));
        }
        StringBuffer sb = new StringBuffer();
        if (this.hasFreeText()) {
            Optional.ofNullable((ChampParameterUtils.PossibleValue)this.freeTextValue.getValue()).ifPresent(ftv -> sb.append(ftv.getValue()));
            sb.append(":");
        }
        sb.append(GLS.getString(this.possibleValues.getItems().stream().map(ChampParameterUtils.PossibleValue::getValue).toList(), (String)";"));
        component.setDefinition(sb.toString());
        Optional.ofNullable((ChampParameterUtils.PossibleValue)this.defaultValue.getValue()).ifPresentOrElse(v -> component.setDefaut(v.getValue()), () -> component.setDefaut(null));
        if (this.hasImage()) {
            this.possibleValues.getItems().forEach(pv -> ChampParameterUtils.saveImage((String)component.getNom(), (ChampParameterUtils.PossibleValue)pv));
        }
    }
}

