/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.neogls.prism.central.vaadin.view.admin.components.ChampParameterUtils;
import com.vaadin.flow.component.html.Image;
import gls.outils.GLS;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class ChampParameterUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampParameterUtils.class);
    protected static final Map<String, String> MAGIC_MIME_TYPES = Map.ofEntries(Map.entry("\u0000\u201e\u00f1\u00d9", "text/plain"), Map.entry("%PDF", "application/pdf"), Map.entry("BM", "image/bmp"), Map.entry("GIF8", "image/gif"), Map.entry("IIMM", "image/tiff"), Map.entry("\u0089PNG", "image/png"), Map.entry("\u00ff\u00d8\u00ff\u00e0", "image/jpg"));

    ChampParameterUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void saveImage(String compName, PossibleValue p) {
        if (p == null || GLS.estVide((String)p.value) || GLS.estVide((String)p.image)) throw new IllegalArgumentException();
        File repComboIcon = new File(ConfigurationFactory.getInstance().get("iconcomboitem.dir"));
        if (!repComboIcon.isDirectory()) throw new RuntimeException("Bad configuration, " + repComboIcon.getAbsolutePath() + " is not a directory");
        File champDir = new File(repComboIcon, compName);
        champDir.mkdir();
        int idx = p.image.indexOf("base64,") + "base64,".length();
        byte[] decodedImg = Base64.getDecoder().decode(p.image.substring(idx));
        Path destinationFile = Paths.get(champDir.getPath(), p.value.concat(".png"));
        try {
            Files.write(destinationFile, decodedImg, new OpenOption[0]);
            log.trace("Saved image to " + destinationFile);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing image for component", e);
        }
    }

    protected static String loadImageFromDiskBase64(String compName, String name) {
        File repComboIcon = new File(ConfigurationFactory.getInstance().get("iconcomboitem.dir"));
        if (repComboIcon.isDirectory()) {
            File champDir = new File(repComboIcon, compName);
            File img = new File(champDir, name + ".png");
            try {
                return ChampParameterUtils.base64Encoder((InputStream)new FileInputStream(img));
            }
            catch (IOException e) {
                log.error("Unable to load image", (Throwable)e);
                return null;
            }
        }
        log.error("Bad configuration, " + repComboIcon.getAbsolutePath() + " is not a directory");
        return null;
    }

    protected static String base64Encoder(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(inputStream.readAllBytes());
        byte[] ba = baos.toByteArray();
        String mediaType = ChampParameterUtils.getMimeType((byte[])ba);
        if (mediaType == null) {
            mediaType = "";
        }
        String headerB64 = new String("data:" + mediaType + ";base64,");
        return headerB64 + Base64.getEncoder().encodeToString(ba);
    }

    protected static String getMimeType(byte[] filecontent) {
        for (String key : MAGIC_MIME_TYPES.keySet()) {
            if (Arrays.compare(filecontent, 0, key.getBytes().length, key.getBytes(), 0, key.getBytes().length) != 0) continue;
            return (String)MAGIC_MIME_TYPES.get(key);
        }
        return null;
    }

    public static String getImageB64(String img) {
        return img.replace("data:/png;base64,", "").replace("data:/gif;base64,", "").replace("data:image/png;base64,", "").replace("data:image/gif;base64,", "");
    }

    public static Image createImg(String id, String alt, int maxHeight, int maxWidth) {
        String img = id != null ? id : "";
        Image ret = new Image(img, id != null ? alt : "");
        ret.setMaxHeight(maxHeight + "px");
        ret.setMaxWidth(maxWidth + "px");
        ret.setHeightFull();
        return ret;
    }
}

