/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.neogls.prism.central.vaadin.view.admin.components.AbstractChampParameterView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.util.List;
import java.util.Optional;

public class ChampDecimalParameterView
extends AbstractChampParameterView<ChampDecimal> {
    private final TextField minimum = ChampDecimalParameterView.createDoubleField();
    private final TextField maximum = ChampDecimalParameterView.createDoubleField();
    private final TextField step = ChampDecimalParameterView.createDoubleField();
    private final Checkbox canBeDisabled = new Checkbox();
    private final TextField defaultValue = ChampDecimalParameterView.createDoubleField();

    ChampDecimalParameterView() {
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        this.add(new Component[]{content});
        content.addFormItem((Component)this.minimum, this.getTranslation("admin.components.minimum", new Object[0]));
        content.addFormItem((Component)this.maximum, this.getTranslation("admin.components.maximum", new Object[0]));
        content.addFormItem((Component)this.step, this.getTranslation("admin.components.step", new Object[0]));
        content.addFormItem((Component)this.canBeDisabled, this.getTranslation("admin.components.candisable", new Object[0]));
        content.addFormItem((Component)this.defaultValue, this.getTranslation("admin.components.default", new Object[0]));
        this.updateUi(new ChampDecimal(""), null);
    }

    void updateComponent(ComposantBean component, boolean mandatory) {
        MapDescription m = MapDescription.newMap();
        Optional.ofNullable((Boolean)this.canBeDisabled.getValue()).ifPresent(v -> m.addValue("desactivable=" + (v != false ? "1" : "0")));
        Optional.ofNullable(this.minimum.getValue()).ifPresent(v -> m.addValue("min=" + v));
        Optional.ofNullable(this.maximum.getValue()).ifPresent(v -> m.addValue("max=" + v));
        Optional.ofNullable(this.step.getValue()).ifPresent(v -> m.addValue("pas=" + v));
        Optional.ofNullable(this.defaultValue.getValue()).ifPresent(v -> component.setDefaut(v.toString()));
        component.setDefinition(m.toString());
    }

    void updateUi(ChampDecimal value, String defaultValue) {
        this.minimum.setValue(String.valueOf(value.getValeurMin()));
        this.maximum.setValue(String.valueOf(value.getValeurMax()));
        this.step.setValue(String.valueOf(value.getPas()));
        this.canBeDisabled.setValue((Object)value.isCheckbox());
        if (defaultValue != null) {
            this.defaultValue.setValue(String.valueOf(Double.parseDouble(defaultValue)));
        }
    }

    static TextField createDoubleField() {
        TextField numberField = new TextField();
        numberField.setPattern("[\\-]?[0-9]*[.]*[0-9]{0,2}");
        numberField.setAllowedCharPattern("[\\-]?[0-9]*[.]*[0-9]{0,2}");
        return numberField;
    }
}

