/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.components;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.neogls.prism.central.vaadin.common.component.Uploader;
import com.neogls.prism.central.vaadin.view.admin.components.ChampParameterUtils;
import com.neogls.prism.central.vaadin.view.admin.components.ChampWithPossibleValuesParameterView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChampChoixImageParameterView<T extends Champ>
extends ChampWithPossibleValuesParameterView<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampChoixImageParameterView.class);
    protected static final String[] ALLOWED_IMAGE_EXTENSION = new String[]{"png", "gif"};

    protected void addNewPossibleValueToForm(FormLayout content) {
        MemoryBuffer memoryBuffer = new MemoryBuffer();
        Uploader upload = new Uploader(memoryBuffer, ".zip", 900000000, "admin.components.possiblevalues.loadimages", Boolean.valueOf(true));
        Span fileRejected = new Span(this.getTranslation("component.error.file.rejected", new Object[0]));
        Div div = new Div(new Component[]{upload, fileRejected});
        FormLayout.FormItem fileRejectedFI = content.addFormItem((Component)div, "");
        fileRejectedFI.setVisible(false);
        upload.addStartedListener((ComponentEventListener & Serializable)e -> fileRejectedFI.setVisible(false));
        upload.addFileRejectedListener((ComponentEventListener & Serializable)e -> fileRejectedFI.setVisible(true));
        upload.addFinishedListener((ComponentEventListener & Serializable)e -> {
            fileRejectedFI.setVisible(false);
            try {
                List pvs = this.readImageArchive(memoryBuffer);
                if (pvs.isEmpty()) {
                    fileRejectedFI.setVisible(true);
                } else {
                    this.setPossibleValues(pvs);
                }
            }
            catch (IOException exception) {
                fileRejectedFI.setVisible(true);
            }
            upload.removeFiles();
        });
        content.addFormItem((Component)upload, "");
    }

    private List<ChampParameterUtils.PossibleValue> readImageArchive(MemoryBuffer memoryBuffer) throws IOException {
        ArrayList<ChampParameterUtils.PossibleValue> values = new ArrayList<ChampParameterUtils.PossibleValue>();
        ZipInputStream zipFile = new ZipInputStream(memoryBuffer.getInputStream());
        ZipEntry zFile = zipFile.getNextEntry();
        while (zFile != null) {
            if (!zFile.isDirectory()) {
                String filename = zFile.getName();
                String ext = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
                if (Arrays.asList(ALLOWED_IMAGE_EXTENSION).contains(ext)) {
                    filename = filename.substring(0, filename.lastIndexOf(46));
                    filename = filename.substring(filename.indexOf("/") + 1, filename.length());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    zipFile.transferTo(bos);
                    byte[] buffer = bos.toByteArray();
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    byte[] first32b = new byte[32];
                    System.arraycopy(buffer, 0, first32b, 0, 32);
                    ChampParameterUtils.PossibleValue value = new ChampParameterUtils.PossibleValue(filename, ChampParameterUtils.base64Encoder((InputStream)is));
                    values.add(value);
                } else {
                    log.warn("Ignore not allowed file in zip archive " + zFile.getName());
                }
            }
            zFile = zipFile.getNextEntry();
        }
        return values;
    }

    protected boolean hasImage() {
        return true;
    }

    void updateUiSpecific(T value, String defaultValue) {
        List names = this.getImagesName(value);
        names.stream().map(name -> new ChampParameterUtils.PossibleValue(name, ChampParameterUtils.loadImageFromDiskBase64((String)value.getNom(), (String)name))).forEach(a -> this.addPossibleValue(a));
    }

    protected abstract List<String> getImagesName(T var1);
}

