/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.circuit;

import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.google.common.collect.Streams;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.util.WSG84Utils;
import com.neogls.prism.central.vaadin.util.mapstruct.condition.NumericalCondition;
import com.neogls.prism.central.vaadin.view.admin.circuit.PrAbs;
import com.neogls.prism.central.vaadin.view.admin.circuit.SensTroncon;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconVaadinBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.ToDoubleFunction;
import org.mapstruct.Context;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(uses={NumericalCondition.class}, imports={Point.class})
public abstract class TronconVaadinBeanMapper {
    public static final TronconVaadinBeanMapper INSTANCE = (TronconVaadinBeanMapper)Mappers.getMapper(TronconVaadinBeanMapper.class);

    @Mappings(value={@Mapping(target="prDebut.pr", source="prDebut"), @Mapping(target="prDebut.abs", source="abscissePrDebut"), @Mapping(target="prFin.pr", source="prFin"), @Mapping(target="prFin.abs", source="abscissePrFin"), @Mapping(target="sens", source="sensNumerique"), @Mapping(target="grammage", conditionQualifiedBy={NumericalCondition.PositiveOrZero.class}), @Mapping(target="largeur", conditionQualifiedBy={NumericalCondition.PositiveOrZero.class}), @Mapping(target="geometry", source="."), @Mapping(target="geometries", source=".")})
    public abstract TronconVaadinBean mapToVaadinBean(Troncon var1, @Context Map<Long, NiveauService> var2);

    @InheritInverseConfiguration
    @Mappings(value={@Mapping(target="prDebut", source="prDebut", qualifiedByName={"pr"}), @Mapping(target="prFin", source="prFin", qualifiedByName={"pr"}), @Mapping(target="abscissePrDebut", source="prDebut", qualifiedByName={"abs"}), @Mapping(target="abscissePrFin", source="prFin", qualifiedByName={"abs"}), @Mapping(target="sensNumerique", source="sens.value"), @Mapping(target="niveauService", source="niveauService.id"), @Mapping(target="circuit", ignore=true), @Mapping(target="departementPrDebut", ignore=true), @Mapping(target="departementPrFin", ignore=true), @Mapping(target="longueur", source="geometry"), @Mapping(target="classification", ignore=true), @Mapping(target="pointDebut", ignore=true), @Mapping(target="pointFin", ignore=true), @Mapping(target="x", expression="java(lineToFloatArray(vaadinBean.getGeometry(), Point::getX))"), @Mapping(target="y", expression="java(lineToFloatArray(vaadinBean.getGeometry(), Point::getY))"), @Mapping(target="tronconId", ignore=true), @Mapping(target="xs", expression="java(lineToDoubleArrayVector(vaadinBean.getGeometries(), Point::getX))"), @Mapping(target="ys", expression="java(lineToDoubleArrayVector(vaadinBean.getGeometries(), Point::getY))")})
    public abstract Troncon mapToEntity(TronconVaadinBean var1);

    protected final SensTroncon getByValue(int value) {
        return SensTroncon.getSensTronconByValue((int)value);
    }

    protected final NiveauService getByValue(Long value, @Context Map<Long, NiveauService> niveauxService) {
        return niveauxService.get(value);
    }

    protected final List<Point> getSGeometry(Troncon entity) {
        return Streams.zip(entity.getXs().stream().flatMapToDouble(Arrays::stream).boxed(), entity.getYs().stream().flatMapToDouble(Arrays::stream).boxed(), Point::new).toList();
    }

    protected final List<List<Point>> getGeometry(Troncon entity) {
        ArrayList<List<Point>> multiline = new ArrayList<List<Point>>();
        Vector xs = entity.getXs();
        Vector ys = entity.getYs();
        for (int i = 0; i < entity.getXs().size(); ++i) {
            ArrayList<Point> line = new ArrayList<Point>();
            for (int j = 0; j < ((double[])xs.get(i)).length; ++j) {
                Point p = Point.ofLatLng((double)((double[])ys.get(i))[j], (double)((double[])xs.get(i))[j]);
                line.add(p);
            }
            multiline.add(line);
        }
        return multiline;
    }

    @Named(value="pr")
    protected final int mapPrAbsPr(PrAbs prAbs) {
        return prAbs != null ? prAbs.getPr() : -1;
    }

    @Named(value="abs")
    protected final int mapPrAbsAbs(PrAbs prAbs) {
        return prAbs != null ? prAbs.getAbs() : -1;
    }

    protected final float[] lineToFloatArray(List<Point> line, ToDoubleFunction<Point> valueGetter) {
        if (line == null) {
            return new float[0];
        }
        float[] ret = new float[line.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (float)valueGetter.applyAsDouble(line.get(i));
        }
        return ret;
    }

    protected final Vector<double[]> lineToDoubleArrayVectors(List<Point> line, ToDoubleFunction<Point> valueGetter) {
        if (line == null) {
            return new Vector<double[]>();
        }
        double[] doubleArray = new double[line.size()];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = valueGetter.applyAsDouble(line.get(i));
        }
        return new Vector<double[]>(List.of(doubleArray));
    }

    protected final Vector<double[]> lineToDoubleArrayVector(List<List<Point>> line, ToDoubleFunction<Point> valueGetter) {
        if (line == null) {
            return new Vector<double[]>();
        }
        Vector<double[]> coord = new Vector<double[]>();
        for (int j = 0; j < line.size(); ++j) {
            double[] doubleArray = new double[line.get(j).size()];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = valueGetter.applyAsDouble(line.get(j).get(i));
            }
            coord.add(doubleArray);
        }
        return coord;
    }

    protected final int computeLineLength(List<Point> line) {
        return (int)Math.round(WSG84Utils.pathLength(line));
    }

    protected final int computeLinesLength(List<List<Point>> line) {
        return line.stream().mapToInt(e -> (int)Math.round(WSG84Utils.pathLength((List)e))).reduce(0, Integer::sum);
    }
}

