/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.circuit;

import com.geolocsystems.prismcentral.beans.NiveauService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.common.component.map.PathPicker;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.util.ConverterUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.ValidatorUtils;
import com.neogls.prism.central.vaadin.util.leaflet.PathOptionsBuilder;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitService;
import com.neogls.prism.central.vaadin.view.admin.circuit.PrAbs;
import com.neogls.prism.central.vaadin.view.admin.circuit.SensTroncon;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconForm;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconVaadinBean;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.validator.RangeValidator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.PathOptions;

public class TronconForm
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TronconForm.class);
    private final TextField description = new TextField(this.getTranslation("admin.circuit.creation.description", new Object[0]));
    private final TextField axe = new TextField(this.getTranslation("admin.circuit.creation.axe", new Object[0]));
    private final TextField prDebut = new TextField(this.getTranslation("admin.circuit.creation.prDebut", new Object[0]));
    private final TextField prFin = new TextField(this.getTranslation("admin.circuit.creation.prFin", new Object[0]));
    private final ComboBox<SensTroncon> sens = new ComboBox(this.getTranslation("admin.circuit.creation.senstroncon", new Object[0]));
    private final Checkbox salage = new Checkbox(this.getTranslation("admin.circuit.creation.salage", new Object[0]));
    private final NumberField grammage = new NumberField(this.getTranslation("admin.circuit.creation.grammage", new Object[0]));
    private final NumberField largeur = new NumberField(this.getTranslation("admin.circuit.creation.largeur", new Object[0]));
    private final ComboBox<NiveauService> niveauService = new ComboBox(this.getTranslation("admin.circuit.creation.niveauservice", new Object[0]));
    private final Checkbox obligatoire = new Checkbox(this.getTranslation("admin.circuit.creation.obligatoire", new Object[0]));
    private final PathPicker geometry;
    private final Button generateGeometry = new Button(this.getTranslation("admin.circuit.creation.generer", new Object[0]), arg_0 -> this.onGenerateGeometryClick(arg_0));
    private final Binder<TronconVaadinBean> binder = new Binder();
    private final CircuitService circuitService;
    private final LeafletMap map;
    private Layer geometryLine;
    private boolean isVH;
    private Binder.Binding<TronconVaadinBean, Boolean> salageBinding;
    private Binder.Binding<TronconVaadinBean, Double> grammageBinding;
    private Binder.Binding<TronconVaadinBean, Double> largeurBinding;
    private TronconVaadinBean value;
    private static final Pattern REGEX_PR_ABS = Pattern.compile("|(-1|\\d{1,7})(\\+(-1|\\d{1,7}))?");
    private static final Validator<String> VALIDATOR_PR_ABS = ValidatorUtils.regexValidator((Pattern)REGEX_PR_ABS, (ErrorMessageProvider & Serializable)ctx -> ctx.getComponent().map(component -> component.getTranslation("admin.circuit.creation.verification.valeurprabscisse", new Object[0])).orElse(""));
    private static final Converter<String, PrAbs> CONVERTER_PR_ABS = ConverterUtils.withNullSupport((SerializableFunction & Serializable)str -> {
        if (str.isEmpty()) {
            return new PrAbs(-1, -1);
        }
        String[] values = str.split("\\+");
        int pr = Integer.parseInt(values[0]);
        int abs = values.length > 1 ? Integer.parseInt(values[1]) : -1;
        return new PrAbs(pr, abs);
    }, (SerializableFunction & Serializable)prAbs -> prAbs.getPr() + "+" + prAbs.getAbs());

    public TronconForm(LeafletMap map, CircuitService circuitService) {
        this.map = map;
        this.circuitService = circuitService;
        this.geometry = new PathPicker(map);
        this.sens.setItemLabelGenerator((ItemLabelGenerator & Serializable)sensTroncon -> this.getTranslation(sensTroncon.getTranslation(), new Object[0]));
        this.sens.setItems((Object[])SensTroncon.values());
        this.salage.addClassName("mt-s");
        this.grammage.setVisible(false);
        this.largeur.setVisible(false);
        this.niveauService.setItemLabelGenerator(NiveauService::getLibelle);
        this.niveauService.setItems((Collection)this.circuitService.getNiveauxServices());
        this.obligatoire.addClassName("mt-s");
        this.geometry.setLabel(this.getTranslation("admin.circuit.creation.geometrie", new Object[0]));
        this.setPadding(false);
        this.setSpacing(false);
        Button bSaveTroncon = new Button(this.getTranslation("admin.circuit.creation.save-troncon", new Object[0]), arg_0 -> this.onSaveClick(arg_0));
        bSaveTroncon.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        Button bCancel = new Button(this.getTranslation("admin.cancel", new Object[0]), arg_0 -> this.onCancelClick(arg_0));
        this.add(new Component[]{this.description, this.axe, this.prDebut, this.prFin, this.sens, this.salage, this.grammage, this.largeur, this.niveauService, this.obligatoire, this.geometry, this.generateGeometry, new Hr(), bSaveTroncon, bCancel});
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.salage.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.grammage.setVisible(((Boolean)event.getValue()).booleanValue());
            this.largeur.setVisible(((Boolean)event.getValue()).booleanValue());
            this.grammageBinding.setReadOnly((Boolean)event.getValue() == false);
            this.largeurBinding.setReadOnly((Boolean)event.getValue() == false);
        });
        this.geometry.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.drawGeometry((List)event.getValue(), ((Boolean)this.obligatoire.getValue()).booleanValue()));
        this.obligatoire.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.drawGeometry((List)this.geometry.getValue(), ((Boolean)event.getValue()).booleanValue()));
        this.initBinder();
    }

    private void initBinder() {
        this.binder.forField((HasValue)this.description).asRequired(this.getTranslation("admin.circuit.creation.verification.message", new Object[0])).bind(TronconVaadinBean::getDescription, TronconVaadinBean::setDescription);
        this.binder.forField((HasValue)this.axe).withNullRepresentation((Object)"").bind(TronconVaadinBean::getAxe, TronconVaadinBean::setAxe);
        this.binder.forField((HasValue)this.prDebut).withValidator(VALIDATOR_PR_ABS).withConverter(CONVERTER_PR_ABS).bind(TronconVaadinBean::getPrDebut, TronconVaadinBean::setPrDebut);
        this.binder.forField((HasValue)this.prFin).withValidator(VALIDATOR_PR_ABS).withConverter(CONVERTER_PR_ABS).bind(TronconVaadinBean::getPrFin, TronconVaadinBean::setPrFin);
        this.binder.bind((HasValue)this.sens, TronconVaadinBean::getSens, TronconVaadinBean::setSens);
        this.salageBinding = this.binder.bind((HasValue)this.salage, TronconVaadinBean::isSalage, TronconVaadinBean::setSalage);
        this.grammageBinding = this.binder.forField((HasValue)this.grammage).withValidator((Validator)RangeValidator.of((String)this.getTranslation("admin.circuit.creation.verification.valeurfloat", new Object[0]), (Comparable)Double.valueOf(0.0), null)).bind(TronconVaadinBean::getGrammage, TronconVaadinBean::setGrammage);
        this.largeurBinding = this.binder.forField((HasValue)this.largeur).withValidator((Validator)RangeValidator.of((String)this.getTranslation("admin.circuit.creation.verification.valeurfloat", new Object[0]), (Comparable)Double.valueOf(0.0), null)).bind(TronconVaadinBean::getLargeur, TronconVaadinBean::setLargeur);
        this.binder.bind((HasValue)this.niveauService, TronconVaadinBean::getNiveauService, TronconVaadinBean::setNiveauService);
        this.binder.bind((HasValue)this.obligatoire, TronconVaadinBean::isObligatoire, TronconVaadinBean::setObligatoire);
        this.binder.forField((HasValue)this.geometry).asRequired(Validator.from((SerializablePredicate & Serializable)geometryValue -> geometryValue.size() >= 2, (String)this.getTranslation("admin.circuit.creation.verification.troncon-geometry.min-points", new Object[0]))).bind(TronconVaadinBean::getGeometry, TronconVaadinBean::setGeometry);
    }

    public void setIsVH(boolean isVH) {
        this.isVH = isVH;
        this.salage.setEnabled(isVH);
        this.salageBinding.setReadOnly(!isVH);
    }

    public void setValue(TronconVaadinBean value) {
        this.value = value;
        this.updateUI();
    }

    private void updateUI() {
        this.binder.readBean((Object)this.value);
        if (!this.isVH) {
            this.salage.setValue((Object)false);
        }
        this.geometry.setInUse(this.value == null);
        if (this.value != null) {
            this.drawGeometry(this.value.getGeometry(), this.value.isObligatoire());
        } else {
            this.clearGeometry();
        }
    }

    private void clearGeometry() {
        if (this.geometryLine != null) {
            this.geometryLine.remove();
            this.geometryLine = null;
        }
    }

    private void drawGeometry(List<Point> geometry, boolean isObligatoire) {
        this.clearGeometry();
        this.geometryLine = LeafletUtils.createLinearWithCircleOnEnds(geometry, (PathOptions)PathOptionsBuilder.builder().color("#008000").dashArray(isObligatoire ? null : "1 5").build().build());
        this.geometryLine.addTo(this.map);
    }

    private void onGenerateGeometryClick(ClickEvent<Button> event) {
        List points = (List)this.geometry.getValue();
        if (points.size() < 2) {
            return;
        }
        try {
            TronconVaadinBean troncon = TronconVaadinBean.builder().build();
            this.binder.writeBeanAsDraft((Object)troncon);
            this.circuitService.generateTronconFromGeometry(troncon);
            this.binder.readBean((Object)troncon);
        }
        catch (ICartoService.LocalisationException e) {
            log.debug("Localisation error", (Throwable)e);
            ErrorDialog.builder().title(this.getTranslation("localisation.erreur.titre", new Object[0])).message(this.getTranslation(e.getErreurI18n(), new Object[0])).build().open();
        }
    }

    private void onSaveClick(ClickEvent<Button> event) {
        try {
            TronconVaadinBean newValue = this.value != null ? this.value.toBuilder().build() : TronconVaadinBean.builder().build();
            this.binder.writeBean((Object)newValue);
            this.fireEvent((ComponentEvent)new SaveEvent(this, event.isFromClient(), newValue, this.value));
        }
        catch (ValidationException e) {
            ErrorDialog.builder().title(this.getTranslation("admin.circuit.creation.verification.titre", new Object[0])).message(this.getTranslation("admin.circuit.creation.verification.message", new Object[0])).build().open();
        }
    }

    private void onCancelClick(ClickEvent<Button> event) {
        this.fireEvent((ComponentEvent)new CancelEvent(this, event.isFromClient()));
    }

    public void addSaveListener(ComponentEventListener<SaveEvent> listener) {
        this.addListener(SaveEvent.class, listener);
    }

    public void addCancelListener(ComponentEventListener<CancelEvent> listener) {
        this.addListener(CancelEvent.class, listener);
    }
}

