/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.circuit;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.service.security.SecurityService;
import com.neogls.prism.central.vaadin.util.WSG84Utils;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitCopyMapper;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconVaadinBean;
import com.neogls.prism.central.vaadin.view.admin.circuit.ValeurChampLocalisationMapper;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class CircuitService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final SecurityService securityService;
    private final ICartoService cartoService;
    private final CircuitCopyMapper circuitCopyMapper;
    private final ValeurChampLocalisationMapper valeurChampLocalisationMapper;

    public List<Circuit> getAllCircuits() {
        return this.businessService.getListeCircuits();
    }

    public void createCircuit(Circuit circuit) {
        this.businessService.creerCircuitTroncons(circuit);
    }

    public Circuit copyCircuit(Circuit circuit) {
        return this.circuitCopyMapper.copy(circuit);
    }

    public void updateCircuit(Circuit circuit) {
        this.businessService.updateCircuit(circuit);
    }

    public List<Troncon> getTronconByCircuit(Circuit circuit) {
        return this.businessService.getCircuitTroncons(circuit);
    }

    public Map<Integer, ModuleMetier> getModulesMetierByCode() {
        return this.businessService.getModulesMetiers();
    }

    public Map<String, Delegation> getDelegationActiveByName() {
        return Maps.uniqueIndex((Iterable)this.businessService.getDelegationsActives(), Delegation::getNom);
    }

    public List<NiveauService> getNiveauxServices() {
        return this.businessService.getNiveauxService();
    }

    public Map<Long, NiveauService> getNiveauServiceById() {
        return Maps.uniqueIndex((Iterable)this.businessService.getNiveauxService(), NiveauService::getId);
    }

    public String getCartoLayerURL() {
        return WMSController.Helper.createWMSLayerURL((String)((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.url.saisie.circuits").orElseThrow()), (String)"departement");
    }

    public void generateTronconFromGeometry(TronconVaadinBean troncon) throws ICartoService.LocalisationException {
        List geometry = troncon.getGeometry();
        if (geometry == null || geometry.size() < 2) {
            return;
        }
        ValeurChampLocalisation localisation = new ValeurChampLocalisation("");
        localisation.setPositionDebut(this.valeurChampLocalisationMapper.pointToPosition((Point)geometry.get(0)));
        localisation.setPositionFin(this.valeurChampLocalisationMapper.pointToPosition((Point)geometry.get(geometry.size() - 1)));
        localisation.setPrDebut(-1);
        localisation.setAbsPrDebut(-1);
        localisation.setPrFin(-1);
        localisation.setAbsPrFin(-1);
        this.cartoService.localisation(localisation);
        this.valeurChampLocalisationMapper.patchTroncon(localisation, troncon);
        troncon.setGeometry(WSG84Utils.douglasPeucker((List)troncon.getGeometry(), (double)3.0));
    }

    @Generated
    public CircuitService(IBusinessService businessService, ConfigurationService configurationService, SecurityService securityService, ICartoService cartoService, CircuitCopyMapper circuitCopyMapper, ValeurChampLocalisationMapper valeurChampLocalisationMapper) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.securityService = securityService;
        this.cartoService = cartoService;
        this.circuitCopyMapper = circuitCopyMapper;
        this.valeurChampLocalisationMapper = valeurChampLocalisationMapper;
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Generated
    public SecurityService getSecurityService() {
        return this.securityService;
    }
}

