/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.circuit;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_CIRCUITS"})
@Route(value="admin/circuit", layout=PrismLayout.class)
public class CircuitAdminView
extends AbstractAdminView<Circuit> {
    private final CircuitService circuitService;
    private Map<Integer, ModuleMetier> moduleMetierByCode = Map.of();
    private boolean showArchived = false;

    protected void init() {
        this.beforeControls.add(new Component[]{new Checkbox(this.getTranslation("admin.circuit.checkbox.archives", new Object[0]), arg_0 -> this.onShowArchivedChange(arg_0))});
        this.grid.addColumn(Circuit::getNom).setHeader(this.getTranslation("admin.circuit.head.code", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)circuit -> ((ModuleMetier)this.moduleMetierByCode.get(Integer.parseInt(circuit.getType()))).getNom()).setHeader(this.getTranslation("admin.circuit.type", new Object[0]));
        this.grid.addColumn(Circuit::getDelegation).setHeader(this.getTranslation("global.delegation", new Object[0]));
        this.grid.addColumn(Circuit::getCentre).setHeader(this.getTranslation("global.centre", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)circuit -> circuit.isArchive() ? this.getTranslation("Global.Yes", new Object[0]) : null).setHeader(this.getTranslation("admin.circuit.head.archive", new Object[0]));
    }

    private void onShowArchivedChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.showArchived = (Boolean)event.getValue();
        this.grid.getDataProvider().refreshAll();
    }

    protected Collection<Circuit> refreshItems() {
        this.moduleMetierByCode = this.circuitService.getModulesMetierByCode();
        return this.circuitService.getAllCircuits();
    }

    protected void createItem(SaveEvent<Circuit> saveEvent) {
        this.circuitService.createCircuit((Circuit)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<Circuit> saveEvent) {
        this.circuitService.updateCircuit((Circuit)saveEvent.getValue());
    }

    protected void deleteItem(Circuit item) {
    }

    protected boolean isDeletable(Circuit item) {
        return false;
    }

    protected AbstractAdminEditDialog<Circuit> createEditDialog(Circuit item) {
        return new CircuitAdminEditDialog(item, this.circuitService);
    }

    protected boolean filter(Circuit item) {
        return this.showArchived || !item.isArchive();
    }

    public String getPageTitle() {
        return this.getTranslation("admin.circuit.title", new Object[0]);
    }

    @Generated
    public CircuitAdminView(CircuitService circuitService) {
        this.circuitService = circuitService;
    }
}

