/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.circuit;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.util.ConverterUtils;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitService;
import com.neogls.prism.central.vaadin.view.admin.circuit.PrAbs;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconForm;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconVaadinBean;
import com.neogls.prism.central.vaadin.view.admin.circuit.TronconVaadinBeanMapper;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.grid.ColumnTextAlign;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.controls.LayersControl;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

public class CircuitAdminEditDialog
extends AbstractAdminEditDialog<Circuit> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CircuitAdminEditDialog.class);
    private final TextField name = new TextField(this.getTranslation("admin.circuit.nom", new Object[0]));
    private final ComboBox<Delegation> cbDelegation = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
    private final ComboBox<Centre> cbCenter = new ComboBox(this.getTranslation("global.centre", new Object[0]));
    private final ComboBox<ModuleMetier> type = new ComboBox(this.getTranslation("admin.circuit.type", new Object[0]));
    private final ComboBox<NiveauService> niveauService = new ComboBox(this.getTranslation("admin.circuit.creation.niveauservice", new Object[0]));
    private final Checkbox archive = new Checkbox(this.getTranslation("admin.circuit.isarchive", new Object[0]));
    private final Binder<Circuit> binder = new Binder();
    private final List<TronconVaadinBean> troncons = new ArrayList();
    private final Map<Integer, ModuleMetier> modulesMetiers;
    private final Map<String, Delegation> delegations;
    private final Table<String, String, Centre> centers;
    private final Map<Long, NiveauService> niveauxService;
    private final CircuitService circuitService;
    private final Component formComponent;
    private final TronconForm formTroncon;
    private final LeafletMap map;
    private final LayerGroup lineGroup = new LayerGroup(new Layer[0]);
    private final Grid<TronconVaadinBean> tronconGrid;
    private static final String KEY_SALAGE = "SALAGE";
    private static final String KEY_GRAMMAGE = "GRAMMAGE";
    private static final String KEY_LARGEUR = "LARGEUR";
    private static final List<String> VH_COLUMN_KEYS = List.of("SALAGE", "GRAMMAGE", "LARGEUR");

    CircuitAdminEditDialog(Circuit oldItem, CircuitService circuitService) {
        super((Object)oldItem);
        this.circuitService = Objects.requireNonNull(circuitService);
        if (this.isEdition()) {
            oldItem.setTroncons(this.circuitService.getTronconByCircuit(oldItem));
        }
        this.modulesMetiers = this.circuitService.getModulesMetierByCode();
        this.delegations = circuitService.getDelegationActiveByName();
        this.centers = this.createCenterTable(this.delegations.values());
        this.niveauxService = circuitService.getNiveauServiceById();
        this.formComponent = this.createForm();
        this.map = this.createMap();
        this.tronconGrid = this.createTronconGrid();
        this.formTroncon = this.createTronconForm();
        Div formContainer = new Div(new Component[]{this.formComponent, this.formTroncon});
        formContainer.setSizeFull();
        Scroller scroller = new Scroller((Component)formContainer);
        scroller.setHeightFull();
        scroller.setWidth(15.0f, Unit.EM);
        scroller.addClassName("flex-shrink-0");
        HorizontalLayout formAndMap = new HorizontalLayout(new Component[]{scroller, this.map});
        formAndMap.setSizeFull();
        SplitLayout content = new SplitLayout((Component)formAndMap, (Component)this.tronconGrid);
        content.setOrientation(SplitLayout.Orientation.VERTICAL);
        content.setSizeFull();
        content.addSplitterDragendListener((ComponentEventListener & Serializable)event -> this.map.invalidateSize());
        this.add(new Component[]{content});
        this.setSizeFull();
        Button bAddTroncon = new Button(this.getTranslation("admin.circuit.creation.add-troncon", new Object[0]), (Component)VaadinIcon.PLUS.create(), arg_0 -> this.onAddTronconClick(arg_0));
        bAddTroncon.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.getCustomFooter().add(new Component[]{bAddTroncon});
        this.cbDelegation.setItems(this.delegations.values());
        this.cbDelegation.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.cbCenter.clear();
            this.cbCenter.setItems(((ComboBox)event.getSource()).isEmpty() ? List.of() : ((Delegation)event.getValue()).getCentres());
            this.cbCenter.setReadOnly(((ComboBox)event.getSource()).isEmpty());
        });
        this.type.setItems(this.modulesMetiers.values());
        this.type.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            boolean isVH = 1 == ((ModuleMetier)event.getValue()).getCode();
            this.formTroncon.setIsVH(isVH);
            for (String key : VH_COLUMN_KEYS) {
                this.tronconGrid.getColumnByKey(key).setVisible(isVH);
            }
        });
        this.niveauService.setItems(this.niveauxService.values());
        AuthenticatedUser currentUser = circuitService.getSecurityService().getAuthenticatedUser();
        if (currentUser.getDelegation() != null) {
            this.cbDelegation.setReadOnly(true);
            this.cbDelegation.setValue((Object)currentUser.getDelegation());
        }
        if (currentUser.getCentre() != null) {
            this.cbCenter.setReadOnly(true);
            this.cbCenter.setValue((Object)currentUser.getCentre());
        }
        this.initBinder();
        this.binder.readBean((Object)oldItem);
        if (oldItem != null) {
            if (oldItem.getTroncons() != null) {
                this.troncons.addAll(oldItem.getTroncons().stream().map(troncon -> TronconVaadinBeanMapper.INSTANCE.mapToVaadinBean(troncon, this.niveauxService)).toList());
            }
            for (int i = 0; i < this.troncons.size(); ++i) {
                this.troncons.set(i, ((TronconVaadinBean)this.troncons.get(i)).toBuilder().indice(i).build());
            }
            this.redrawTroncons();
            this.tronconGrid.getListDataView().refreshAll();
        }
    }

    private TronconForm createTronconForm() {
        TronconForm form = new TronconForm(this.map, this.circuitService);
        form.setVisible(false);
        form.setEnabled(false);
        form.addSaveListener(arg_0 -> this.onTronconSaved(arg_0));
        form.addCancelListener(arg_0 -> this.onTronconEditionCanceled(arg_0));
        form.setIsVH(false);
        return form;
    }

    private Table<String, String, Centre> createCenterTable(Collection<Delegation> delegations) {
        HashBasedTable table = HashBasedTable.create();
        for (Delegation d : delegations) {
            for (Centre c : d.getCentres()) {
                table.put((Object)d.getNom(), (Object)c.getNom(), (Object)c);
            }
        }
        return Tables.unmodifiableTable((Table)table);
    }

    private Component createForm() {
        this.cbDelegation.setClearButtonVisible(true);
        this.cbCenter.setClearButtonVisible(true);
        this.cbCenter.setReadOnly(true);
        this.type.setItemLabelGenerator(ModuleMetier::getNom);
        this.niveauService.setClearButtonVisible(true);
        this.niveauService.setPlaceholder(this.getTranslation("admin.circuit.creation.niveauservice.aucun", new Object[0]));
        this.niveauService.setItemLabelGenerator(NiveauService::getLibelle);
        this.archive.addClassName("mt-s");
        VerticalLayout form = new VerticalLayout(new Component[]{this.name, this.cbDelegation, this.cbCenter, this.type, this.niveauService, this.archive});
        form.setAlignItems(FlexComponent.Alignment.STRETCH);
        form.setPadding(false);
        form.setSpacing(false);
        form.setSizeFull();
        return form;
    }

    private Grid<TronconVaadinBean> createTronconGrid() {
        Grid grid = new Grid();
        grid.addColumn(TronconVaadinBean::getIndice).setFlexGrow(0).setAutoWidth(true);
        grid.addComponentColumn(arg_0 -> this.createMoveButtons(arg_0)).setFlexGrow(0).setAutoWidth(true);
        grid.addColumn(TronconVaadinBean::getDescription).setHeader("DESCRIPTION").setFlexGrow(3);
        grid.addColumn(this.withNullRepresentation(TronconVaadinBean::getAxe, (Object)"-")).setHeader("AXE");
        ((Grid.Column)grid.addColumn(this.renderPrAbs(TronconVaadinBean::getPrDebut)).setHeader("PR D\u00c9BUT").setTextAlign(ColumnTextAlign.CENTER)).setFlexGrow(0).setAutoWidth(true);
        ((Grid.Column)grid.addColumn(this.renderPrAbs(TronconVaadinBean::getPrFin)).setHeader("PR FIN").setTextAlign(ColumnTextAlign.CENTER)).setFlexGrow(0).setAutoWidth(true);
        ((Grid.Column)grid.addColumn(TronconVaadinBean::isSalage).setHeader(KEY_SALAGE).setFlexGrow(0).setAutoWidth(true).setTextAlign(ColumnTextAlign.CENTER)).setKey(KEY_SALAGE).setVisible(false);
        ((Grid.Column)grid.addColumn(this.withNullRepresentation(TronconVaadinBean::getGrammage, (Object)"-")).setHeader(KEY_GRAMMAGE).setTextAlign(ColumnTextAlign.END)).setFlexGrow(0).setAutoWidth(true).setKey(KEY_GRAMMAGE).setVisible(false);
        ((Grid.Column)grid.addColumn(this.withNullRepresentation(TronconVaadinBean::getLargeur, (Object)"-")).setHeader(KEY_LARGEUR).setTextAlign(ColumnTextAlign.END)).setFlexGrow(0).setAutoWidth(true).setKey(KEY_LARGEUR).setVisible(false);
        grid.addComponentColumn(arg_0 -> this.createDeleteButton(arg_0)).setFlexGrow(0).setAutoWidth(true);
        grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT});
        grid.addSelectionListener(arg_0 -> this.onTronconSelectionChange(arg_0));
        grid.setItems((Collection)this.troncons);
        return grid;
    }

    public <T> ValueProvider<T, String> renderPrAbs(Function<T, PrAbs> getter) {
        return (ValueProvider & Serializable)item -> {
            PrAbs prAbs = (PrAbs)getter.apply(item);
            return prAbs != null ? prAbs.getPr() + "+" + prAbs.getAbs() : null;
        };
    }

    public <T> ValueProvider<T, Object> withNullRepresentation(Function<T, ?> getter, Object nullRepresentation) {
        return (ValueProvider & Serializable)item -> Objects.requireNonNullElse(getter.apply(item), nullRepresentation);
    }

    private void swapTroncons(int src, int dst) {
        this.troncons.set(src, this.troncons.set(dst, ((TronconVaadinBean)this.troncons.get(src)).toBuilder().indice(dst).build()).toBuilder().indice(src).build());
        this.tronconGrid.getDataProvider().refreshAll();
        this.tronconGrid.deselectAll();
        this.tronconGrid.select((Object)((TronconVaadinBean)this.troncons.get(dst)));
        this.tronconGrid.scrollToIndex(dst);
    }

    private Component createMoveButtons(TronconVaadinBean troncon) {
        Button bMoveUp = new Button((Component)VaadinIcon.ARROW_UP.create(), (ComponentEventListener & Serializable)event -> {
            int index;
            for (index = 0; index < this.troncons.size() && this.troncons.get(index) != troncon; ++index) {
            }
            if (index != 0) {
                this.swapTroncons(index, index - 1);
            }
        });
        Button bMoveDown = new Button((Component)VaadinIcon.ARROW_DOWN.create(), (ComponentEventListener & Serializable)event -> {
            int index;
            for (index = 0; index < this.troncons.size() && this.troncons.get(index) != troncon; ++index) {
            }
            if (index != this.troncons.size() - 1) {
                this.swapTroncons(index, index + 1);
            }
        });
        bMoveUp.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        bMoveDown.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        return new Div(new Component[]{bMoveUp, bMoveDown});
    }

    private Component createDeleteButton(TronconVaadinBean troncon) {
        Button deleteButton = new Button((Component)VaadinIcon.TRASH.create(), (ComponentEventListener & Serializable)event -> {
            int index;
            this.tronconGrid.deselectAll();
            for (index = 0; index < this.troncons.size() && this.troncons.get(index) != troncon; ++index) {
            }
            this.troncons.remove(index);
            while (index < this.troncons.size()) {
                this.troncons.set(index, ((TronconVaadinBean)this.troncons.get(index)).toBuilder().indice(index).build());
                ++index;
            }
            this.tronconGrid.getDataProvider().refreshAll();
            this.redrawTroncons();
        });
        deleteButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        return deleteButton;
    }

    private LeafletMap createMap() {
        LeafletMap tmpMap = LeafletUtils.createMap((ConfigurationService)this.circuitService.getConfigurationService());
        LayersControl layersControl = new LayersControl();
        layersControl.addTo(tmpMap);
        TileLayer baseLayer = new TileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png");
        TileLayer carto = new TileLayer(this.circuitService.getCartoLayerURL());
        baseLayer.addTo(tmpMap);
        carto.addTo(tmpMap);
        layersControl.addOverlay((Layer)baseLayer, "OSM");
        layersControl.addOverlay((Layer)carto, "Carto");
        return tmpMap;
    }

    private void initBinder() {
        this.binder.forField((HasValue)this.name).asRequired().bind(Circuit::getNom, Circuit::setNom);
        this.binder.forField((HasValue)this.cbDelegation).withConverter(ConverterUtils.withNullSupport(Delegation::getNom, this.delegations::get)).bind(Circuit::getDelegation, Circuit::setDelegation);
        this.binder.forField((HasValue)this.cbCenter).bind((ValueProvider & Serializable)circuit -> (Centre)this.centers.get((Object)circuit.getDelegation(), (Object)circuit.getCentre()), (Setter & Serializable)(circuit, centre) -> circuit.setCentre(centre != null ? centre.getNom() : null));
        this.binder.forField((HasValue)this.type).asRequired().withConverter(ConverterUtils.withNullSupport(ModuleMetier::getCode, this.modulesMetiers::get)).withConverter(ConverterUtils.withNullSupport(String::valueOf, Integer::parseInt)).bind(Circuit::getType, Circuit::setType);
        this.binder.forField((HasValue)this.niveauService).withConverter(ConverterUtils.withNullSupport(NiveauService::getId, this.niveauxService::get)).bind(Circuit::getNiveauService, Circuit::setNiveauService);
        this.binder.bind((HasValue)this.archive, Circuit::isArchive, Circuit::setArchive);
    }

    private void redrawTroncons() {
        this.lineGroup.clearLayers();
        LatLngBounds bounds = new LatLngBounds();
        for (TronconVaadinBean troncon : this.troncons) {
            List multiline = troncon.getGeometries();
            for (List l : multiline) {
                Polyline line = new Polyline(l.stream().map(LeafletUtils::pointToLatLng).toList());
                line.setColor("blue");
                line.setWeight(4.0);
                line.setFill(false);
                if (!troncon.isObligatoire()) {
                    line.setDashArray("1 5");
                }
                bounds.extend(line.getBounds());
                line.addTo(this.lineGroup);
            }
        }
        this.lineGroup.addTo(this.map);
        this.map.whenReady((ComponentEventListener & Serializable)event -> {
            this.map.fitBounds(bounds);
            event.unregisterListener();
        });
    }

    private void showGeneralForm() {
        this.formComponent.setVisible(true);
        this.formTroncon.setVisible(false);
        this.formTroncon.setEnabled(false);
        this.lineGroup.addTo(this.map);
        this.formTroncon.setValue(null);
    }

    private void showTronconForm(TronconVaadinBean troncon) {
        this.formComponent.setVisible(false);
        this.formTroncon.setVisible(true);
        this.formTroncon.setEnabled(true);
        this.lineGroup.remove();
        this.formTroncon.setValue(troncon);
    }

    private void onAddTronconClick(ClickEvent<Button> event) {
        this.tronconGrid.deselectAll();
        this.showTronconForm(null);
    }

    private void onTronconSelectionChange(SelectionEvent<Grid<TronconVaadinBean>, TronconVaadinBean> event) {
        event.getFirstSelectedItem().ifPresentOrElse(arg_0 -> this.showTronconForm(arg_0), () -> this.showGeneralForm());
    }

    private void onTronconSaved(TronconForm.SaveEvent event) {
        TronconVaadinBean troncon = event.getValue();
        if (event.getOldValue() == null) {
            this.troncons.add(troncon.toBuilder().indice(this.troncons.size()).build());
        } else {
            this.troncons.set(troncon.getIndice(), troncon);
        }
        this.tronconGrid.deselectAll();
        this.tronconGrid.getDataProvider().refreshAll();
        this.showGeneralForm();
        this.redrawTroncons();
    }

    private void onTronconEditionCanceled(TronconForm.CancelEvent event) {
        this.tronconGrid.deselectAll();
        this.showGeneralForm();
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.circuit.creation.titre", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.circuit.edit", new Object[0]);
    }

    protected Circuit getValue() throws ValidationException {
        Circuit value = this.isEdition() ? this.circuitService.copyCircuit((Circuit)this.oldItem) : new Circuit();
        this.binder.writeBean((Object)value);
        value.setTroncons(this.troncons.stream().map(arg_0 -> ((TronconVaadinBeanMapper)TronconVaadinBeanMapper.INSTANCE).mapToEntity(arg_0)).toList());
        if (value.getTroncons().isEmpty()) {
            throw new CustomValidationException(this.getTranslation("admin.circuit.creation.verification.notroncon", new Object[0]));
        }
        return value;
    }
}

