/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.center;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.neogls.prism.central.vaadin.view.admin.center.CenterAdminEditDialog;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_DELEGATION_CENTRE"})
@Route(value="/admin/center", layout=PrismLayout.class)
public class CenterAdminView
extends AbstractAdminView<Centre> {
    private final IBusinessService businessService;

    protected void init() {
        this.grid.addColumn(Centre::getNom).setHeader(this.getTranslation("admin.centre.head.identifiant", new Object[0]));
        this.grid.addColumn(Centre::getDelegation).setHeader(this.getTranslation("global.delegation", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)center -> center.isArchive() ? this.getTranslation("admin.centre.archive", new Object[0]) : null).setHeader(this.getTranslation("admin.centre.head.archive", new Object[0]));
    }

    protected Collection<Centre> refreshItems() {
        return this.businessService.getDelegations().stream().map(Delegation::getCentres).flatMap(Collection::stream).toList();
    }

    protected void createItem(SaveEvent<Centre> saveEvent) {
        this.businessService.creerCentre((Centre)saveEvent.getValue());
    }

    protected void updateItem(SaveEvent<Centre> saveEvent) {
        this.businessService.updateCentre((Centre)saveEvent.getValue());
    }

    protected void deleteItem(Centre item) {
        throw new UnsupportedOperationException("A center cannot be deleted.");
    }

    protected AbstractAdminEditDialog<Centre> createEditDialog(Centre item) {
        return new CenterAdminEditDialog(item, (Collection)this.businessService.getDelegations());
    }

    protected boolean isDeletable(Centre item) {
        return false;
    }

    public String getPageTitle() {
        return this.getTranslation("admin.centre.title", new Object[0]);
    }

    @Generated
    public CenterAdminView(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

