/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin.center;

import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CenterAdminEditDialog
extends AbstractAdminEditDialog<Centre> {
    private final TextField name = new TextField();
    private final ComboBox<String> delegation = new ComboBox();
    private final Checkbox archive = new Checkbox();
    private final NumberField west = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField south = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField east = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final NumberField north = new NumberField((HasValue.ValueChangeListener & Serializable)event -> this.updateBoundsErrorMessage());
    private final Component boundsErrorMessage = new Div(this.getTranslation("admin.error.coord", new Object[0]));
    private final Binder<Centre> binder = new Binder();
    private final Binder<Bounds> boundsBinder = new Binder();

    CenterAdminEditDialog(Centre oldItem, Collection<Delegation> delegations) {
        super((Object)oldItem);
        this.configureFields(delegations);
        this.configureBinder();
        this.binder.readBean((Object)oldItem);
        this.boundsBinder.readBean((Object)(oldItem != null ? oldItem.getBounds() : null));
    }

    private void configureFields(Collection<Delegation> delegations) {
        this.delegation.setItems(delegations.stream().map(Delegation::getNom).toList());
        this.west.setValueChangeMode(ValueChangeMode.LAZY);
        this.south.setValueChangeMode(ValueChangeMode.LAZY);
        this.east.setValueChangeMode(ValueChangeMode.LAZY);
        this.north.setValueChangeMode(ValueChangeMode.LAZY);
        this.boundsErrorMessage.addClassNames(new String[]{"text-error", "text-xs", "box-border"});
        this.boundsErrorMessage.getStyle().set("padding-left", "156px");
        this.boundsErrorMessage.setVisible(false);
        FormLayout content = new FormLayout();
        content.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
        content.setMaxWidth(30.0f, Unit.EM);
        content.getStyle().set("--vaadin-form-item-label-width", "10em");
        content.addFormItem((Component)this.name, this.getTranslation("admin.centre.name", new Object[0]));
        content.addFormItem((Component)this.delegation, this.getTranslation("admin.centre.delegation", new Object[0]));
        content.addFormItem((Component)this.archive, this.getTranslation("admin.centre.archive", new Object[0]));
        Span coordsLabel = new Span(this.getTranslation("admin.coord", new Object[0]));
        coordsLabel.addClassName("mt-l");
        content.add(new Component[]{coordsLabel});
        content.addFormItem((Component)this.west, this.getTranslation("admin.minx", new Object[0]));
        content.addFormItem((Component)this.south, this.getTranslation("admin.miny", new Object[0]));
        content.addFormItem((Component)this.east, this.getTranslation("admin.maxx", new Object[0]));
        content.addFormItem((Component)this.north, this.getTranslation("admin.maxy", new Object[0]));
        content.add(new Component[]{this.boundsErrorMessage});
        this.add(new Component[]{content});
    }

    private void updateBoundsErrorMessage() {
        this.boundsErrorMessage.setVisible(this.isBoundsInvalid());
    }

    private boolean isBoundsInvalid() {
        return (!this.west.isEmpty() || !this.south.isEmpty() || !this.east.isEmpty() || !this.north.isEmpty()) && (this.west.isEmpty() || this.south.isEmpty() || this.east.isEmpty() || this.north.isEmpty()) || this.west.isInvalid() || this.south.isInvalid() || this.east.isInvalid() || this.north.isInvalid();
    }

    private boolean validateBounds() {
        boolean invalid = this.isBoundsInvalid();
        this.boundsErrorMessage.setVisible(invalid);
        return !invalid;
    }

    private void configureBinder() {
        this.binder.forField((HasValue)this.name).asRequired(this.getTranslation("admin.centre.error.nom", new Object[0])).bind(Centre::getNom, Centre::setNom).setReadOnly(this.isEdition());
        this.binder.forField((HasValue)this.delegation).asRequired(this.getTranslation("admin.centre.error.delegation", new Object[0])).bind(Centre::getDelegation, Centre::setDelegation).setReadOnly(this.isEdition());
        this.binder.bind((HasValue)this.archive, Centre::isArchive, Centre::setArchive);
        this.boundsBinder.bind((HasValue)this.west, Bounds::getMinx, Bounds::setMinx);
        this.boundsBinder.bind((HasValue)this.south, Bounds::getMiny, Bounds::setMiny);
        this.boundsBinder.bind((HasValue)this.east, Bounds::getMaxx, Bounds::setMaxx);
        this.boundsBinder.bind((HasValue)this.north, Bounds::getMaxy, Bounds::setMaxy);
    }

    protected String getCreateTitle() {
        return this.getTranslation("admin.centre.title", new Object[0]);
    }

    protected String getEditTitle() {
        return this.getTranslation("admin.centre.title", new Object[0]);
    }

    private Bounds getBounds() throws ValidationException {
        if (!this.validateBounds()) {
            throw new CustomValidationException(this.getTranslation("admin.error.coord", new Object[0]));
        }
        if (this.west.isEmpty()) {
            return null;
        }
        Bounds bounds = new Bounds();
        this.boundsBinder.writeBean((Object)bounds);
        return bounds;
    }

    protected Centre getValue() throws ValidationException {
        Bounds bounds = this.getBounds();
        Centre value = this.isEdition() ? (Centre)this.oldItem : new Centre();
        this.binder.writeBean((Object)value);
        value.setBounds(bounds);
        return value;
    }
}

