/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.beans.NatureBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminView;
import com.neogls.prism.central.vaadin.view.admin.EventTypeAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;

@RolesAllowed(value={"ACTION_ADMIN_TYPES_EVENEMENTS"})
@Route(value="admin/event-type", layout=PrismLayout.class)
public class EventTypeAdminView
extends AbstractAdminView<NatureBean> {
    private final IBusinessService businessService;
    private Map<Integer, ModuleMetier> moduleMetierByCode;
    private String filterValue = "";

    protected void init() {
        String yes = this.getTranslation("Global.Yes", new Object[0]);
        String no = this.getTranslation("Global.No", new Object[0]);
        this.grid.addColumn(NatureBean::getLibelle).setHeader(this.getTranslation("admin.events.head.description", new Object[0]));
        this.grid.addColumn(NatureBean::getCode).setHeader(this.getTranslation("admin.events.head.code", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)natureBean -> natureBean.getListeComposantsCommun().size() + natureBean.getListeComposantsNature().size()).setHeader(this.getTranslation("admin.events.head.nbchamps", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)natureBean -> ((ModuleMetier)this.moduleMetierByCode.get(natureBean.getCodeModuleMetier())).getLibelle()).setHeader(this.getTranslation("admin.events.head.modulemetier", new Object[0]));
        this.grid.addColumn(NatureBean::getIndice).setHeader(this.getTranslation("admin.events.head.indice", new Object[0]));
        this.grid.addColumn((ValueProvider & Serializable)natureBean -> natureBean.isActive() ? yes : no).setHeader(this.getTranslation("admin.events.head.archive", new Object[0]));
    }

    protected Collection<NatureBean> refreshItems() {
        this.moduleMetierByCode = Maps.uniqueIndex(this.businessService.getModulesMetiers().values(), ModuleMetier::getCode);
        return this.businessService.getListeNaturePerso(true);
    }

    protected void createItem(SaveEvent<NatureBean> event) {
    }

    protected void updateItem(SaveEvent<NatureBean> event) {
    }

    protected void deleteItem(NatureBean item) {
    }

    protected AbstractAdminEditDialog<NatureBean> createEditDialog(NatureBean item) {
        return new EventTypeAdminEditDialog(item);
    }

    protected boolean hasFilter() {
        return true;
    }

    protected void onFilterValueChange(String filterValue) {
        this.filterValue = filterValue.trim().toLowerCase();
    }

    protected boolean filter(NatureBean item) {
        return item.getCode().toLowerCase().contains(this.filterValue) || item.getLibelle().toLowerCase().contains(this.filterValue);
    }

    protected String getFilterPlaceholder() {
        return this.getTranslation("admin.types.search", new Object[0]);
    }

    public String getPageTitle() {
        return this.getTranslation("admin.events.title", new Object[0]);
    }

    @Generated
    public EventTypeAdminView(IBusinessService businessService) {
        this.businessService = businessService;
    }
}

