/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin;

import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.view.admin.AbstractAdminEditDialog;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.server.Command;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;

public abstract class AbstractAdminView<T>
extends VerticalLayout
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAdminView.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final String logPrefix = this.getClass().getSimpleName();
    private final TextField filter = new TextField(arg_0 -> this.onFilterValueChange(arg_0));
    private final Button add = new Button(this.getTranslation("admin.add", new Object[0]), (Component)VaadinIcon.PLUS.create(), (ComponentEventListener & Serializable)e -> this.onCreateClick());
    private final Button edit = new Button(this.getTranslation("admin.edit", new Object[0]), (Component)VaadinIcon.PENCIL.create(), (ComponentEventListener & Serializable)e -> this.onEditClick());
    private final Button delete = new Button(this.getTranslation("admin.delete", new Object[0]), (Component)VaadinIcon.TRASH.create(), (ComponentEventListener & Serializable)e -> this.onDeleteClick());
    private final ProgressBar progressBar = new ProgressBar();
    protected final Grid<T> grid = new Grid();
    protected final HorizontalLayout beforeControls = new HorizontalLayout();
    protected final HorizontalLayout afterControls = new HorizontalLayout();
    private final HorizontalLayout controls = new HorizontalLayout(new Component[]{this.filter, this.beforeControls, this.add, this.edit, this.delete, this.afterControls});
    protected Collection<T> unfilteredItems;
    private GridListDataView<T> dataView = null;

    protected AbstractAdminView() {
        this.filter.setValueChangeMode(ValueChangeMode.LAZY);
        this.beforeControls.addClassName("ml-auto");
        this.edit.setEnabled(false);
        this.delete.setEnabled(false);
        this.delete.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        this.controls.setWidthFull();
        this.controls.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.controls.setFlexGrow(1.0, new HasElement[]{this.filter});
        this.controls.setEnabled(false);
        this.progressBar.setWidthFull();
        this.progressBar.setMaxWidth(50.0f, Unit.EM);
        this.progressBar.setIndeterminate(true);
        this.progressBar.addClassNames(new String[]{"mx-auto", "my-xl"});
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES});
        this.grid.setSizeFull();
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> {
            this.edit.setEnabled(event.getFirstSelectedItem().isPresent());
            this.delete.setEnabled(event.getFirstSelectedItem().map(arg_0 -> this.isDeletable(arg_0)).orElse(false).booleanValue());
        });
        this.grid.addItemDoubleClickListener((ComponentEventListener & Serializable)event -> this.openEditDialog(event.getItem()));
        this.add(new Component[]{this.controls, this.progressBar, this.grid});
        this.setSizeFull();
    }

    @PostConstruct
    private void commonInit() {
        this.init();
        if (this.hasFilter()) {
            this.onFilterValueChange(this.filter.getValue());
            this.filter.setPlaceholder(this.getFilterPlaceholder());
        } else {
            this.filter.setVisible(false);
        }
        boolean beforeControlsVisible = this.beforeControls.getChildren().findAny().isPresent();
        this.beforeControls.setVisible(beforeControlsVisible);
        this.add.setClassName("ml-auto", !beforeControlsVisible);
        this.add.setEnabled(this.isCreatable());
        this.afterControls.setVisible(this.afterControls.getChildren().findAny().isPresent());
        this.addAttachListener((ComponentEventListener & Serializable)event -> this.reloadItems());
    }

    private void reloadItems() {
        this.progressBar.setVisible(true);
        this.controls.setEnabled(false);
        this.grid.setVisible(false);
        this.grid.setItems(List.of());
        EXECUTOR_SERVICE.submit((Runnable)new DelegatingSecurityContextRunnable(() -> {
            try {
                log.debug("[{}] Loading items", (Object)this.logPrefix);
                this.unfilteredItems = this.refreshItems();
                log.debug("[{}] Items loaded", (Object)this.logPrefix);
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    this.dataView = (GridListDataView)this.grid.setItems(this.unfilteredItems);
                    this.dataView.addFilter(arg_0 -> this.filter(arg_0));
                }));
            }
            catch (Exception e) {
                log.error("[{}] Error while loading items", (Object)this.logPrefix, (Object)e);
            }
            finally {
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    this.progressBar.setVisible(false);
                    this.controls.setEnabled(true);
                    this.grid.setVisible(true);
                }));
            }
        }));
    }

    private void tryExecute(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            ErrorDialog.builder().title(this.getTranslation("global.erreur", new Object[0])).message(e.getLocalizedMessage()).build().open();
            throw e;
        }
    }

    protected abstract void init();

    protected abstract Collection<T> refreshItems();

    protected abstract void createItem(SaveEvent<T> var1);

    protected abstract void updateItem(SaveEvent<T> var1);

    protected abstract void deleteItem(T var1);

    protected abstract AbstractAdminEditDialog<T> createEditDialog(T var1);

    protected boolean isCreatable() {
        return true;
    }

    protected boolean isDeletable(T item) {
        return true;
    }

    protected boolean hasFilter() {
        return false;
    }

    protected void onFilterValueChange(String filterValue) {
    }

    protected boolean filter(T item) {
        return true;
    }

    protected String getFilterPlaceholder() {
        return null;
    }

    private void onFilterValueChange(HasValue.ValueChangeEvent<String> event) {
        this.onFilterValueChange((String)event.getValue());
        if (this.dataView != null) {
            this.dataView.refreshAll();
        }
    }

    private void onCreateClick() {
        AbstractAdminEditDialog dialog = this.createEditDialog(null);
        dialog.addSaveListener((ComponentEventListener & Serializable)saveEvent -> this.tryExecute(() -> {
            this.createItem(saveEvent);
            this.reloadItems();
        }));
        dialog.open();
    }

    private void onEditClick() {
        Optional selectedItem = this.grid.getSelectionModel().getFirstSelectedItem();
        if (selectedItem.isEmpty()) {
            return;
        }
        this.openEditDialog(selectedItem.get());
    }

    private void openEditDialog(T item) {
        AbstractAdminEditDialog dialog = this.createEditDialog(Objects.requireNonNull(item));
        dialog.addSaveListener((ComponentEventListener & Serializable)saveEvent -> this.tryExecute(() -> {
            this.updateItem(saveEvent);
            this.reloadItems();
        }));
        dialog.open();
    }

    private void onDeleteClick() {
        ConfirmDialog.builder().title(this.getTranslation("Global.Confirmation", new Object[0])).text(this.getTranslation("Global.Conformation.Message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("Global.Yes", new Object[0])).buttonVariants(List.of(ButtonVariant.LUMO_ERROR, ButtonVariant.LUMO_PRIMARY)).listener((ComponentEventListener & Serializable)event -> this.tryExecute(() -> this.grid.getSelectionModel().getFirstSelectedItem().ifPresent(item -> {
            this.deleteItem(item);
            this.reloadItems();
        }))).build()).cancel(ButtonConfig.builder().text(this.getTranslation("Global.No", new Object[0])).build()).build().open();
    }
}

