/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.admin;

import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.common.exception.CustomValidationException;
import com.neogls.prism.central.vaadin.view.admin.SaveEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.ValidationException;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdminEditDialog<T>
extends Dialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAdminEditDialog.class);
    private final String logPrefix = this.getClass().getSimpleName();
    protected final T oldItem;
    private final HorizontalLayout customFooter = new HorizontalLayout();
    private final Button cancel = new Button(this.getTranslation("admin.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
    private final Button save = new Button(this.getTranslation("admin.save", new Object[0]), arg_0 -> this.onSaveClick(arg_0));

    protected AbstractAdminEditDialog(T oldItem) {
        this.oldItem = oldItem;
        this.customFooter.setSpacing(false);
        this.customFooter.addClassNames(new String[]{"flex-grow", "gap-s"});
        this.save.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.setHeaderTitle(oldItem == null ? this.getCreateTitle() : this.getEditTitle());
        this.getFooter().add(new Component[]{this.customFooter, this.cancel, this.save});
        this.setCloseOnOutsideClick(false);
    }

    protected final boolean isCreation() {
        return this.oldItem == null;
    }

    protected final boolean isEdition() {
        return this.oldItem != null;
    }

    protected abstract String getCreateTitle();

    protected abstract String getEditTitle();

    protected abstract T getValue() throws ValidationException;

    private void onSaveClick(ClickEvent<Button> event) {
        try {
            Object value = this.getValue();
            this.fireEvent((ComponentEvent)new SaveEvent(this, event.isFromClient(), value, this.oldItem));
            this.close();
        }
        catch (ValidationException e) {
            ErrorDialog.builder().title("").message(e.getMessage()).build().open();
            log.error("[{}] Validation error: {}", (Object)this.logPrefix, (Object)e.getMessage());
        }
        catch (CustomValidationException e) {
            ErrorDialog.builder().title("").message(e.getMessage()).build().open();
            log.error("[{}] Custom validation error: {}", (Object)this.logPrefix, (Object)e.getMessage());
        }
    }

    public void addSaveListener(ComponentEventListener<SaveEvent<T>> listener) {
        this.addListener(SaveEvent.class, listener);
    }

    @Generated
    protected HorizontalLayout getCustomFooter() {
        return this.customFooter;
    }
}

