/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.addcommentdialog;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.security.SecurityService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class AddActionDialogService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final SecurityService securityService;

    public List<String> getTypeAction(Evenement evenement) {
        ArrayList<String> listeFiltree = new ArrayList<String>();
        List liste = this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "actions.type").orElse(MetierCommun.getListe((Object[])ConstantesPrismCommun.ACTIONS_DEFAUT));
        if (evenement != null) {
            for (String s : ConstantesPrismCommun.ACTIONS_COMPATIBLES_EVENEMENTS) {
                if (!MetierCommun.estDedans((List)liste, (Object)s)) continue;
                listeFiltree.add(s);
            }
        } else {
            for (String s : ConstantesPrismCommun.ACTIONS_COMPATIBLES_COMMENTAIRE) {
                if (!MetierCommun.estDedans((List)liste, (Object)s)) continue;
                listeFiltree.add(s);
            }
        }
        return listeFiltree;
    }

    public List<String> getDestinataires() {
        return this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "actions.soustype.appel").orElse(MetierCommun.getListe((Object[])ConstantesPrismCommun.APPEL_RECU_DEFAUT));
    }

    public List<String> getTypesActivites() {
        return this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "actions.soustype.activite").orElse(MetierCommun.getListe((Object[])ConstantesPrismCommun.ACTION_SOUS_TYPE_ACTIVITE));
    }

    public List<String> getNatureAppel() {
        return this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "actions.nature.appel").orElse(null);
    }

    public String getMcig() {
        return this.securityService.getAuthenticatedUser().getMainCourante().getId();
    }

    public void ajoutCommentaire(Commentaire com) {
        this.businessService.ajoutCommentaire(this.securityService.getAuthenticatedUser().getMainCourante(), com);
    }

    public void nouvelleAction(ActionCentral actionCentral) {
        this.businessService.nouvelleAction(actionCentral);
    }

    @Generated
    public AddActionDialogService(IBusinessService businessService, ConfigurationService configurationService, SecurityService securityService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.securityService = securityService;
    }
}

