/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.addcommentdialog;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialogService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextFieldBase;
import gls.outils.GLS;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.List;

public class AddActionDialog
extends Dialog {
    private final AddActionDialogService service;
    private final Evenement evenement;
    private ComboBox typeAction;
    private ComboBox listeAction;
    private ComboBox natureAction;
    private DateTimePicker dateDebut;
    private Checkbox chkDateFin;
    private DateTimePicker dateFin;
    private TextFieldBase<?, String> commentaire;

    public AddActionDialog(AddActionDialogService service, Evenement evenement) {
        this.service = service;
        this.evenement = evenement;
        this.setHeaderTitle(this.getTranslation("action.libelle", new Object[0]));
        Button bCancel = new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        Button bValidate = new Button(this.getTranslation("generic.validate", new Object[0]), arg_0 -> this.onValidateAction(arg_0));
        this.getFooter().add(new Component[]{bCancel, bValidate});
        VerticalLayout layout = new VerticalLayout(new Component[]{this.createActionDetails()});
        layout.setPadding(false);
        layout.setWidth(35.0f, Unit.EM);
        layout.setAlignItems(FlexComponent.Alignment.STRETCH);
        layout.addClassName("pt-s");
        this.add(new Component[]{layout});
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.addClassName("visa-confirm-dialog");
    }

    private Component createActionDetails() {
        FormLayout actionDetails = new FormLayout();
        actionDetails.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0px", 1)));
        this.typeAction = new ComboBox();
        this.listeAction = new ComboBox();
        this.natureAction = new ComboBox();
        this.dateDebut = new DateTimePicker();
        this.chkDateFin = new Checkbox();
        this.dateFin = new DateTimePicker();
        this.commentaire = new TextArea();
        this.dateDebut.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateFin.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateDebut.setValue(LocalDateTime.now());
        this.typeAction.setItems((Collection)this.service.getTypeAction(this.evenement));
        this.typeAction.addValueChangeListener((HasValue.ValueChangeListener & Serializable)valueChanged -> this.changementAction());
        this.chkDateFin.addValueChangeListener((HasValue.ValueChangeListener & Serializable)checkboxBooleanComponentValueChangeEvent -> this.afficheDateFin());
        this.afficheDateFin();
        actionDetails.addFormItem((Component)this.typeAction, this.getTranslation("action.type", new Object[0]));
        actionDetails.addFormItem((Component)this.listeAction, this.getTranslation("action.liste", new Object[0]));
        actionDetails.addFormItem((Component)this.natureAction, this.getTranslation("action.nature", new Object[0]));
        actionDetails.addFormItem((Component)this.dateDebut, this.getTranslation("action.date", new Object[0]));
        actionDetails.addFormItem((Component)this.chkDateFin, "");
        actionDetails.addFormItem((Component)this.dateFin, this.getTranslation("action.datefin", new Object[0]));
        actionDetails.addFormItem((Component)this.commentaire, this.getTranslation("action.commentaire", new Object[0]));
        return actionDetails;
    }

    private String getTypeAction() {
        if (this.typeAction.getValue() != null) {
            return this.typeAction.getValue().toString();
        }
        return "";
    }

    private void changementAction() {
        if (this.typeAction.getValue() != null) {
            if (this.estTypeAppel()) {
                this.chargerActions(this.service.getDestinataires());
                this.chargerNaturesActions();
                this.afficherDateFin(true);
            } else {
                switch (this.getTypeAction()) {
                    case "Appel \u00e9mis": {
                        this.chargerActions(this.service.getDestinataires());
                        this.afficherDateFin(true);
                        break;
                    }
                    case "Appel re\u00e7u": {
                        this.chargerActions(this.service.getDestinataires());
                        this.afficherDateFin(true);
                        break;
                    }
                    case "D\u00e9but d'activit\u00e9": {
                        this.chargerActions(this.service.getTypesActivites());
                        this.afficherDateFin(false);
                        break;
                    }
                    case "Fin d'activit\u00e9": {
                        this.chargerActions(this.service.getTypesActivites());
                        this.afficherDateFin(false);
                        break;
                    }
                    default: {
                        this.chargerActions(null);
                        this.afficherDateFin(true);
                    }
                }
            }
        }
    }

    public boolean estTypeAppel() {
        return GLS.estDansLaListe((String[])ConstantesPrismCommun.ACTIONS_DESTINATAIRES, (String)this.getTypeAction());
    }

    public boolean estTypeActivite() {
        return GLS.egal((String)this.getTypeAction(), (String)"D\u00e9but d'activit\u00e9") || GLS.egal((String)this.getTypeAction(), (String)"Fin d'activit\u00e9");
    }

    public boolean aDateFin() {
        return this.estTypeAppel();
    }

    public int getTypeCommentaire() {
        if (this.estTypeAppel()) {
            return this.evenement != null ? 1 : 5;
        }
        switch (GLS.getString((Object)this.typeAction)) {
            case "Appel \u00e9mis": {
                return this.evenement != null ? 1 : 5;
            }
            case "Appel re\u00e7u": {
                return this.evenement != null ? 1 : 5;
            }
            case "D\u00e9but d'activit\u00e9": {
                return 10;
            }
            case "Fin d'activit\u00e9": {
                return 11;
            }
        }
        return 0;
    }

    private void afficheDateFin() {
        this.dateFin.setEnabled(((Boolean)this.chkDateFin.getValue()).booleanValue());
        if (((Boolean)this.chkDateFin.getValue()).booleanValue()) {
            this.dateFin.setValue(((LocalDateTime)this.dateDebut.getValue()).plusMinutes(15L));
        }
    }

    protected void chargerNaturesActions() {
        if (this.natureAction != null) {
            this.natureAction.clear();
            List liste = null;
            if (this.estTypeAppel()) {
                liste = this.service.getNatureAppel();
            }
            if (liste != null) {
                this.natureAction.setItems((Collection)liste);
                this.natureAction.setValue(liste.get(0));
                this.natureAction.setVisible(true);
            } else {
                this.natureAction.setVisible(false);
            }
        } else {
            this.natureAction.setVisible(false);
        }
    }

    private void chargerActions(List<String> actions) {
        this.listeAction.clear();
        if (!GLS.estVide(actions)) {
            this.listeAction.setItems(actions);
            this.listeAction.setVisible(true);
            this.listeAction.setValue((Object)actions.get(0));
        } else {
            this.listeAction.setVisible(false);
        }
    }

    private void afficherDateFin(boolean etat) {
        if (!etat) {
            this.chkDateFin.setValue((Object)false);
            this.dateFin.setValue(null);
        }
        this.dateFin.setVisible(etat);
    }

    private void onValidateAction(ClickEvent<Button> event) {
        StringBuffer sb = new StringBuffer();
        ActionCentral ac = new ActionCentral();
        if (this.evenement != null) {
            ac.setCodeEvenement(this.evenement.getCodeEvenement());
        } else {
            ac.setCodeEvenement("");
        }
        if (!this.typeAction.isEmpty()) {
            sb.append(this.typeAction.getValue().toString());
            ac.setType(GLS.getString((String)this.typeAction.getValue().toString()));
        }
        if (!this.listeAction.isEmpty()) {
            if (!GLS.estVide((String)sb.toString())) {
                sb.append(" : ");
            }
            sb.append(this.listeAction.getValue().toString());
            ac.setSousType(GLS.getString((String)this.listeAction.getValue().toString()));
        }
        Object nature = "";
        if (!this.natureAction.isEmpty() && this.natureAction.getValue() != null) {
            nature = (String)nature + this.natureAction.getValue().toString();
        }
        if (!GLS.estVide((String)((String)this.commentaire.getValue()))) {
            if (!GLS.estVide((String)sb.toString())) {
                sb.append(" - ");
            }
            if (!GLS.estVide((String)nature)) {
                sb.append((String)nature + " " + ((String)this.commentaire.getValue()).toString());
                ac.setCommentaire((String)nature + " " + ((String)this.commentaire.getValue()).toString());
            } else {
                sb.append(((String)this.commentaire.getValue()).toString());
                ac.setCommentaire(((String)this.commentaire.getValue()).toString());
            }
        } else if (!GLS.estVide((String)nature)) {
            if (!GLS.estVide((String)sb.toString())) {
                sb.append(" - ");
            }
            sb.append((String)nature);
            ac.setCommentaire((String)nature);
        }
        if (!GLS.estVide((String)sb.toString())) {
            ((LocalDateTime)this.dateDebut.getValue()).toEpochSecond(ZoneOffset.of("Z"));
            Commentaire com = MetierCommun.genereCommentaire((String)sb.toString(), (long)DateTimeFormatterUtils.getTimeInMs((DateTimePicker)this.dateDebut), (Evenement)this.evenement, (int)-1, (int)this.getTypeCommentaire());
            ac.setDebut(DateTimeFormatterUtils.getTimeInMs((DateTimePicker)this.dateDebut));
            ac.setMcig(this.service.getMcig());
            this.service.ajoutCommentaire(com);
            if (((Boolean)this.chkDateFin.getValue()).booleanValue() && (((LocalDateTime)this.dateFin.getValue()).equals(this.dateDebut.getValue()) || ((LocalDateTime)this.dateFin.getValue()).isAfter((ChronoLocalDateTime)this.dateDebut.getValue()))) {
                sb.insert(0, "(Fin) ");
                com = MetierCommun.genereCommentaire((String)sb.toString(), (long)DateTimeFormatterUtils.getTimeInMs((DateTimePicker)this.dateFin), (Evenement)this.evenement, (int)-1, (int)this.getTypeCommentaire());
                this.service.ajoutCommentaire(com);
                ac.setFin(DateTimeFormatterUtils.getTimeInMs((DateTimePicker)this.dateFin));
            } else {
                ac.setFin(-1L);
            }
            this.service.nouvelleAction(ac);
            Notification.show((String)"Action enregistr\u00e9e").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
            this.close();
        } else {
            Notification.show((String)"Action non enregistr\u00e9e").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
        }
    }
}

