/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view;

import com.geolocsystems.prismcentral.Constantes;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.MainView;
import com.neogls.prism.central.vaadin.rest.LogoController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.security.PrismAuthenticationProvider;
import com.neogls.prism.central.vaadin.service.security.SecurityService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;

@Route(value="/login")
@AnonymousAllowed
public class LoginView
extends FlexLayout
implements BeforeEnterObserver,
HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginView.class);
    private static final String USERNAME_COOKIE_NAME = "last-user-login";
    private static final int USERNAME_COOKIE_MAX_AGE = (int)Duration.ofDays(15L).toSeconds();
    private final TextField username = new TextField(this.getTranslation("login.username", new Object[0]));
    private final PasswordField password = new PasswordField(this.getTranslation("login.password", new Object[0]));
    private final Button connect = new Button(this.getTranslation("login.action", new Object[0]), arg_0 -> this.onConnectClick(arg_0));
    private final Image logoPRISM = new Image("images/logos/Logo-PRISM.png", "PRISM");
    private final Image logoNeoGLS = new Image("images/logos/Logo-NeoGLS-2.png", "NeoGLS");
    private final AuthenticationManager authenticationManager;
    private final HttpSession session;
    private final SecurityService securityService;
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;

    @PostConstruct
    private void init() {
        VerticalLayout form = new VerticalLayout(new Component[]{this.username, this.password, this.connect});
        form.setMaxWidth(25.0f, Unit.EM);
        form.setSpacing(false);
        form.setWidthFull();
        form.setAlignItems(FlexComponent.Alignment.STRETCH);
        Div spacerTop = new Div();
        Div spacerMiddle = new Div();
        Div spacerBottom = new Div();
        this.logoPRISM.setWidth(25.0f, Unit.EM);
        this.logoNeoGLS.setWidth(8.0f, Unit.EM);
        Span environmentLabel = new Span((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "environnement.libelle").orElse(null));
        this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "environnement.libelle.color").ifPresent(arg_0 -> ((Style)environmentLabel.getStyle()).setColor(arg_0));
        environmentLabel.addClassName("text-l");
        String filename = this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.client.file").orElse("logo.png");
        Image logoClient = new Image(LogoController.Helper.createLogoURL((String)filename), "Client");
        logoClient.setWidth(8.0f, Unit.EM);
        logoClient.getStyle().set("object-fit", "contain");
        Anchor linkLogoNeoGLS = new Anchor(this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.neogls.lien").filter(Predicate.not(String::isBlank)).orElse("https://neogls.com"), new Component[0]);
        linkLogoNeoGLS.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        linkLogoNeoGLS.add(new Component[]{this.logoNeoGLS});
        linkLogoNeoGLS.getStyle().setDisplay(Style.Display.FLEX);
        Anchor linkLogoClient = new Anchor();
        this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.client.lien").filter(Predicate.not(String::isBlank)).ifPresent(arg_0 -> ((Anchor)linkLogoClient).setHref(arg_0));
        linkLogoClient.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        linkLogoClient.add(new Component[]{logoClient});
        linkLogoClient.getStyle().setDisplay(Style.Display.FLEX);
        HorizontalLayout logos = new HorizontalLayout(new Component[]{linkLogoNeoGLS, linkLogoClient});
        logos.setMaxWidth(25.0f, Unit.EM);
        logos.setWidthFull();
        logos.setJustifyContentMode(FlexComponent.JustifyContentMode.EVENLY);
        Span versionLabel = new Span(this.getVersionString());
        versionLabel.addClassNames(new String[]{"mt-m", "text-tertiary"});
        this.add(new Component[]{spacerTop, this.logoPRISM, environmentLabel, form, spacerMiddle, logos, versionLabel, spacerBottom});
        this.setSizeFull();
        this.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        this.setAlignItems(FlexComponent.Alignment.CENTER);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.setFlexGrow(1.0, new HasElement[]{spacerTop});
        this.setFlexGrow(1.0, new HasElement[]{spacerMiddle});
        this.setFlexGrow(1.0, new HasElement[]{spacerBottom});
        this.username.addKeyPressListener(Key.ENTER, (ComponentEventListener & Serializable)e -> this.connect.click(), new KeyModifier[0]);
        this.password.addKeyPressListener(Key.ENTER, (ComponentEventListener & Serializable)e -> this.connect.click(), new KeyModifier[0]);
        this.setUsernameFromCookie();
    }

    private String getVersionString() {
        return "Version %s B\u00e9ta %s".formatted(Constantes.VERSION_CENTRAL, 27);
    }

    private void setUsernameFromCookie() {
        Optional.ofNullable(VaadinService.getCurrentRequest()).map(VaadinRequest::getCookies).stream().flatMap(Arrays::stream).filter(cookie -> USERNAME_COOKIE_NAME.equals(cookie.getName())).findFirst().map(Cookie::getValue).ifPresent(arg_0 -> ((TextField)this.username).setValue(arg_0));
    }

    private void onConnectClick(ClickEvent<Button> event) {
        try {
            this.tryLogin(this.username.getValue(), this.password.getValue());
        }
        catch (AuthenticationException e) {
            Notification.show((String)this.getTranslation("login.error", new Object[0]), (int)3000, (Notification.Position)Notification.Position.MIDDLE).addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        }
    }

    private void tryLogin(String username, String password) throws AuthenticationException {
        Authentication authentication = this.authenticationManager.authenticate(this.createAuthenticationRequest(username, password));
        if (authentication != null && authentication.isAuthenticated()) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
            this.session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
            this.businessService.verifierReferentielMaj();
            this.setUsernameCookieValue(this.securityService.getAuthenticatedUser().getPrismUser().getCode());
            this.getUI().ifPresent(ui -> ui.navigate("/"));
        }
    }

    private void setUsernameCookieValue(String username) {
        VaadinResponse response = VaadinService.getCurrentResponse();
        if (response == null) {
            log.warn("null response, can't set username cookie");
            return;
        }
        Cookie usernameCookie = new Cookie(USERNAME_COOKIE_NAME, username);
        usernameCookie.setMaxAge(USERNAME_COOKIE_MAX_AGE);
        response.addCookie(usernameCookie);
    }

    private Authentication createAuthenticationRequest(String username, String password) {
        return new PrismAuthenticationProvider.PrismAuthentication((Object)username, (Object)password);
    }

    public void beforeEnter(BeforeEnterEvent event) {
        if (this.securityService.isAuthenticated()) {
            event.forwardTo(MainView.class);
        }
    }

    public String getPageTitle() {
        return this.getTranslation("login.caption", new Object[0]);
    }

    @Generated
    public LoginView(AuthenticationManager authenticationManager, HttpSession session, SecurityService securityService, IBusinessService businessService, ConfigurationService configurationService) {
        this.authenticationManager = authenticationManager;
        this.session = session;
        this.securityService = securityService;
        this.businessService = businessService;
        this.configurationService = configurationService;
    }
}

