/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.util.vaadin;

import com.vaadin.flow.server.InputStreamFactory;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedInputStreamFactory
implements InputStreamFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedInputStreamFactory.class);
    private final InputStreamFactory factory;
    private byte[] resource = null;

    public CachedInputStreamFactory(@Nonnull InputStreamFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public CachedInputStreamFactory(@Nonnull Supplier<byte[]> resourceDataSupplier) {
        Objects.requireNonNull(resourceDataSupplier);
        this.factory = (InputStreamFactory & Serializable)() -> new ByteArrayInputStream((byte[])resourceDataSupplier.get());
    }

    public synchronized InputStream createInputStream() {
        if (this.resource == null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 InputStream dataInputStream = this.factory.createInputStream();){
                dataInputStream.transferTo(baos);
                this.resource = baos.toByteArray();
                log.atDebug().addArgument(() -> "%.2f".formatted((double)this.resource.length / 1000.0)).log("Cached {} kB of resource data");
            }
            catch (IOException e) {
                this.resource = new byte[0];
                log.error("Couldn't get the resource data", (Throwable)e);
            }
        }
        return new ByteArrayInputStream(this.resource);
    }
}

