/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.util;

import com.neogls.prism.central.vaadin.service.bean.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.SphericalCoordinates;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

/*
 * Exception performing whole class analysis ignored.
 */
public class WSG84Utils {
    public static final double MEAN_EARTH_RADIUS = 6371008.8;

    public static double distance(Point p1, Point p2) {
        double lat1 = Math.toRadians(p1.getY());
        double lng1 = Math.toRadians(p1.getX());
        double lat2 = Math.toRadians(p2.getY());
        double lng2 = Math.toRadians(p2.getX());
        return 1.27420176E7 * Math.asin(Math.sqrt(WSG84Utils.hav((double)(lat1 - lat2)) + Math.cos(lat1) * Math.cos(lat2) * WSG84Utils.hav((double)(lng1 - lng2))));
    }

    public static double pathLength(List<Point> path) {
        if (path.size() < 2) {
            return 0.0;
        }
        double length = 0.0;
        for (int i = 1; i < path.size(); ++i) {
            length += WSG84Utils.distance((Point)path.get(i), (Point)path.get(i - 1));
        }
        return length;
    }

    public static List<Point> douglasPeucker(List<Point> points, double precision) {
        int n = points.size();
        double dmax = 0.0;
        int index = 0;
        Point p1 = points.get(0);
        Point pn = points.get(n - 1);
        for (int i = 1; i < n - 1; ++i) {
            double d = WSG84Utils.distanceToLine((Point)points.get(i), (Point)p1, (Point)pn);
            if (!(d > dmax)) continue;
            index = i;
            dmax = d;
        }
        if (dmax > precision) {
            List recPoints1 = WSG84Utils.douglasPeucker(points.subList(0, index + 1), (double)precision);
            List recPoints2 = WSG84Utils.douglasPeucker(points.subList(index, n), (double)precision);
            ArrayList ret = new ArrayList(recPoints1.size() + recPoints2.size() - 1);
            ret.addAll(recPoints1);
            ret.remove(recPoints1.size() - 1);
            ret.addAll(recPoints2);
            return Collections.unmodifiableList(ret);
        }
        return List.of(p1, pn);
    }

    private static double hav(double theta) {
        return (1.0 - Math.cos(theta)) / 2.0;
    }

    private static double distanceToLine(Point p, Point p1, Point p2) {
        Vector3D a = WSG84Utils.toCartesianCoordinates((Point)p1);
        Vector3D b = WSG84Utils.toCartesianCoordinates((Point)p2);
        Vector3D c = WSG84Utils.toCartesianCoordinates((Point)p);
        Vector3D g = a.crossProduct((Vector)b);
        Vector3D f = c.crossProduct((Vector)g);
        Point t = WSG84Utils.toLatLng((Vector3D)g.crossProduct((Vector)f).normalize().scalarMultiply(6371008.8));
        return WSG84Utils.distance((Point)p, (Point)t);
    }

    public static Vector3D toCartesianCoordinates(Point p) {
        return new SphericalCoordinates(6371008.8, Math.toRadians(p.getLng()), Math.toRadians(90.0 - p.getLat())).getCartesian();
    }

    public static Point toLatLng(Vector3D v) {
        SphericalCoordinates coord = new SphericalCoordinates(v);
        return Point.ofLatLng((double)(90.0 - Math.toDegrees(coord.getPhi())), (double)Math.toDegrees(coord.getTheta()));
    }

    private WSG84Utils() {
        throw new UnsupportedOperationException("Utility class");
    }
}

