/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.util;

import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.Objects;

public class SerializableComparatorUtils {
    public static <T> SerializableComparator<T> reverse(SerializableComparator<T> serializableComparator) {
        Objects.requireNonNull(serializableComparator);
        return (SerializableComparator & Serializable)(o1, o2) -> serializableComparator.compare(o2, o1);
    }

    public static <T> SerializableComparator<T> comparingLong(SerializableFunction<? super T, Long> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (SerializableComparator & Serializable)(o1, o2) -> Long.compare((Long)keyExtractor.apply(o1), (Long)keyExtractor.apply(o2));
    }

    public static <T, U extends Comparable<? super U>> SerializableComparator<T> comparing(SerializableFunction<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (SerializableComparator & Serializable)(c1, c2) -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2));
    }

    private SerializableComparatorUtils() {
        throw new UnsupportedOperationException("Utility class");
    }
}

