/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.util;

import com.geolocsystems.prismandroid.model.Bounds;
import com.neogls.prism.central.vaadin.rest.marker.MarkerController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.util.GeometryUtils;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.map.options.DefaultMapOptions;
import org.vaadin.addons.componentfactory.leaflet.layer.map.options.MapOptions;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.PathOptions;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.structure.LatLngArray;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.structure.MultiLatLngArray;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;
import org.vaadin.addons.componentfactory.leaflet.types.Point;

/*
 * Exception performing whole class analysis ignored.
 */
public class LeafletUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LeafletUtils.class);
    private static final double BOUNDS_MARGIN = 0.1;

    @Deprecated
    public static LatLngBounds getMaxBounds(ConfigurationService configurationService) {
        Double bottom = (Double)configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.maxExtent_bottom").orElseThrow();
        Double left = (Double)configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.maxExtent_left").orElseThrow();
        Double top = (Double)configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.maxExtent_top").orElseThrow();
        Double right = (Double)configurationService.getDouble(ConfigurationService.ConfigurationType.PROPERTY, "carto.maxExtent_right").orElseThrow();
        double marginX = (right - left) * 0.1;
        double marginY = (top - bottom) * 0.1;
        return new LatLngBounds(new LatLng[]{new LatLng(bottom - marginY, left - marginX), new LatLng(top + marginY, right + marginX)});
    }

    @Deprecated
    public static LatLngBounds getMaxBounds(Bounds bounds) {
        double bottom = bounds.getMinx();
        double left = bounds.getMiny();
        double top = bounds.getMaxx();
        double right = bounds.getMaxy();
        double marginX = (right - left) * 0.1;
        double marginY = (top - bottom) * 0.1;
        return new LatLngBounds(new LatLng[]{new LatLng(bottom - marginY, left - marginX), new LatLng(top + marginY, right + marginX)});
    }

    public static LatLngBounds toLeafletMapBounds(Bounds bounds) {
        return LeafletUtils.toLatLngBounds((Bounds)GeometryUtils.extend((Bounds)bounds, (double)0.1));
    }

    public static LatLngBounds toLatLngBounds(Bounds bounds) {
        return new LatLngBounds(new LatLng[]{new LatLng(bounds.getMiny(), bounds.getMinx()), new LatLng(bounds.getMaxy(), bounds.getMaxx())});
    }

    public static LeafletMap createMap(ConfigurationService configurationService) {
        return LeafletUtils.createMap((ConfigurationService)configurationService, null, null);
    }

    public static LeafletMap createMap(ConfigurationService configurationService, @Nullable LatLngBounds initialBounds, @Nullable Integer initialZoom) {
        LatLngBounds bounds = LeafletUtils.toLeafletMapBounds((Bounds)configurationService.getBounds());
        log.debug("BOUNDS: {}", (Object)bounds);
        DefaultMapOptions options = new DefaultMapOptions();
        options.setMinZoom((Integer)configurationService.getInt(ConfigurationService.ConfigurationType.PROPERTY, "carto.minZoomLevel").orElseThrow());
        options.setMaxZoom((Integer)configurationService.getInt(ConfigurationService.ConfigurationType.PROPERTY, "carto.maxZoomLevel").orElseThrow());
        options.setMaxBoundsViscosity(1.0);
        LeafletMap map = new LeafletMap((MapOptions)options);
        map.setView(new LatLng(0.0, 0.0), 0);
        map.onLoad(event -> {
            log.debug("map.onLoad");
            map.fitBounds(Objects.requireNonNullElse(initialBounds, bounds));
            if (initialZoom != null) {
                map.setZoom(initialZoom.intValue());
            }
            map.setMaxBounds(bounds);
            event.unregisterListener();
        });
        return map;
    }

    public static Layer createOSMLayer() {
        return new TileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png");
    }

    public static Layer createLinearWithCircleOnEnds(List<com.neogls.prism.central.vaadin.service.bean.Point> points, PathOptions pathOptions) {
        LayerGroup layer = new LayerGroup(new Layer[0]);
        if (points.isEmpty()) {
            return layer;
        }
        List<LatLng> locations = points.stream().map(LeafletUtils::pointToLatLng).toList();
        Polyline polyline = new Polyline(locations);
        polyline.setStyle(pathOptions);
        polyline.addTo(layer);
        Marker markerStart = new Marker(locations.get(0));
        markerStart.setIcon(LeafletUtils.createCircledTextIcon(null, (String)pathOptions.getColor()));
        markerStart.addTo(layer);
        if (locations.size() > 1) {
            Marker markerEnd = new Marker(locations.get(locations.size() - 1));
            markerEnd.setIcon(LeafletUtils.createCircledTextIcon((String)"", (String)pathOptions.getColor()));
            markerEnd.addTo(layer);
        }
        return layer;
    }

    public static Layer createLinearWithOrdinalMarkers(List<com.neogls.prism.central.vaadin.service.bean.Point> points, PathOptions pathOptions) {
        LayerGroup layer = new LayerGroup(new Layer[0]);
        if (points.isEmpty()) {
            return layer;
        }
        List<LatLng> locations = points.stream().map(LeafletUtils::pointToLatLng).toList();
        Polyline polyline = new Polyline(locations);
        polyline.setStyle(pathOptions);
        polyline.addTo(layer);
        for (int i = 0; i < locations.size(); ++i) {
            Marker marker = new Marker(locations.get(i));
            marker.setIcon(LeafletUtils.createOrdinalIcon((int)i, (String)pathOptions.getColor()));
            marker.addTo(layer);
        }
        return layer;
    }

    private static Icon createOrdinalIcon(int i, String color) {
        return LeafletUtils.createCircledTextIcon((String)String.valueOf(i), (String)color);
    }

    private static Icon createCircledTextIcon(String text, String color) {
        Icon icon = new Icon(MarkerController.Helper.createCircledTextURL((String)color, (String)text));
        icon.setIconSize(LeafletUtils.leafletPoint((int)16, (int)16));
        icon.setIconAnchor(LeafletUtils.leafletPoint((int)8, (int)8));
        icon.setShadowSize(null);
        return icon;
    }

    public static LatLng pointToLatLng(com.neogls.prism.central.vaadin.service.bean.Point point) {
        return new LatLng(point.getY(), point.getX());
    }

    public static LatLngArray pointListToLatLngArray(List<com.neogls.prism.central.vaadin.service.bean.Point> pointList) {
        return new LatLngArray(pointList.stream().map(LeafletUtils::pointToLatLng).toList());
    }

    public static MultiLatLngArray pointMultiListToMultiLatLngArray(List<List<com.neogls.prism.central.vaadin.service.bean.Point>> pointMultiList) {
        MultiLatLngArray multiLatLngArray = new MultiLatLngArray();
        pointMultiList.stream().map(LeafletUtils::pointListToLatLngArray).forEach(arg_0 -> multiLatLngArray.add(arg_0));
        return multiLatLngArray;
    }

    public static com.neogls.prism.central.vaadin.service.bean.Point latLngToPoint(LatLng latLng) {
        return new com.neogls.prism.central.vaadin.service.bean.Point(latLng.getLng().doubleValue(), latLng.getLat().doubleValue());
    }

    public static Point leafletPoint(int x, int y) {
        return new Point((double)x, (double)y);
    }

    public static Point scale(Point point, double scale) {
        return LeafletUtils.leafletPoint((int)((int)Math.round(point.getX() * scale)), (int)((int)Math.round(point.getY() * scale)));
    }

    @Generated
    private LeafletUtils() {
    }
}

