/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.neogls.prism.central.vaadin.layout.Menu;
import com.neogls.prism.central.vaadin.layout.MenuService;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialogService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.spring.security.AuthenticationContext;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Uses.Container(value={@Uses(value=DateTimePicker.class), @Uses(value=Select.class)})
public class PrismLayout
extends VerticalLayout
implements RouterLayout,
BeforeEnterObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrismLayout.class);
    private final MenuService menuService;
    private final AuthenticationContext authenticationContext;
    private final AddActionDialogService addActionService;
    private Menu menu;
    private final Component container = new Div();

    @PostConstruct
    private void init() {
        this.setSizeFull();
        this.setPadding(false);
        this.setSpacing(false);
        this.menu = new Menu(this.menuService, this.authenticationContext, this.addActionService);
        this.add(new Component[]{this.menu, this.container});
        this.addClassName("prism-layout");
        this.container.addClassName("router-layout-container");
    }

    public void beforeEnter(BeforeEnterEvent event) {
        log.debug("Navigating to: {}", (Object)event.getNavigationTarget());
        this.menu.setCurrentView(event.getNavigationTarget());
    }

    public void showRouterLayoutContent(@Nullable HasElement content) {
        if (content != null) {
            this.container.getElement().appendChild(new Element[]{content.getElement()});
        }
    }

    @Generated
    public PrismLayout(MenuService menuService, AuthenticationContext authenticationContext, AddActionDialogService addActionService) {
        this.menuService = menuService;
        this.authenticationContext = authenticationContext;
        this.addActionService = addActionService;
    }
}

