/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActiviteEntretien;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.neogls.prism.central.vaadin.layout.ChangePasswordDialog;
import com.neogls.prism.central.vaadin.layout.ChangePasswordService;
import com.neogls.prism.central.vaadin.layout.PrismMenu;
import com.neogls.prism.central.vaadin.layout.ViewAccessCheckerService;
import com.neogls.prism.central.vaadin.rest.LogoController;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.security.SecurityService;
import com.neogls.prism.central.vaadin.service.util.ListUtils;
import com.neogls.prism.central.vaadin.util.StreamUtils;
import com.neogls.prism.central.vaadin.view.admin.EventTypeAdminView;
import com.neogls.prism.central.vaadin.view.admin.center.CenterAdminView;
import com.neogls.prism.central.vaadin.view.admin.circuit.CircuitAdminView;
import com.neogls.prism.central.vaadin.view.admin.components.ComponentsAdminView;
import com.neogls.prism.central.vaadin.view.admin.delegation.DelegationAdminView;
import com.neogls.prism.central.vaadin.view.admin.fauchage.passes.FauchagePassesParCentreAdminView;
import com.neogls.prism.central.vaadin.view.admin.fauchage.passes.FauchagePassesParCircuitAdminView;
import com.neogls.prism.central.vaadin.view.admin.mail.distribution.MailDistributionConfigurationView;
import com.neogls.prism.central.vaadin.view.admin.mail.list.MailListAdminView;
import com.neogls.prism.central.vaadin.view.admin.mail.recipient.MailRecipientAdminView;
import com.neogls.prism.central.vaadin.view.admin.profile.ProfileAdminView;
import com.neogls.prism.central.vaadin.view.admin.publication.configuration.PublicationConfigurationView;
import com.neogls.prism.central.vaadin.view.admin.publication.message.AlertMessageAdminView;
import com.neogls.prism.central.vaadin.view.admin.publication.parameter.PublicationParameterConfigurationAdminView;
import com.neogls.prism.central.vaadin.view.admin.user.UserAdminView;
import com.neogls.prism.central.vaadin.view.admin.vehicle.VehicleAdminView;
import com.neogls.prism.central.vaadin.view.admin.vehicletype.VehicleTypeAdminView;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookSearchView;
import com.neogls.prism.central.vaadin.view.export.vh.AnalysePatrouillesVH;
import com.neogls.prism.central.vaadin.view.mct.activites.MctActivites;
import com.neogls.prism.central.vaadin.view.mct.cch.historique.HistoriqueSaisieCCH;
import com.neogls.prism.central.vaadin.view.mct.cch.historique.visualisation.VisualisationCCH;
import com.neogls.prism.central.vaadin.view.mct.cch.saisie.SaisieCCH;
import com.neogls.prism.central.vaadin.view.mct.entretien.MctEntretien;
import com.neogls.prism.central.vaadin.view.mct.fauchage.MctFauchage;
import com.neogls.prism.central.vaadin.view.mct.fauchage.historique.FauchageHistorique;
import com.neogls.prism.central.vaadin.view.mct.fauchage.stats.FauchageExploitationSchemaView;
import com.neogls.prism.central.vaadin.view.mct.intervention.MctIntervention;
import com.neogls.prism.central.vaadin.view.mct.patrimoine.MctPatrimoine;
import com.neogls.prism.central.vaadin.view.mct.patrol.MctPatrouillage;
import com.neogls.prism.central.vaadin.view.mct.pietoncycle.MctPietonCycle;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouille;
import com.neogls.prism.central.vaadin.view.mct.tableaudebord.MctTableauDeBord;
import com.neogls.prism.central.vaadin.view.mct.travauxneufs.MctTravauxNeufs;
import com.neogls.prism.central.vaadin.view.mct.vh.MctVh;
import com.neogls.prism.central.vaadin.view.stats.Stats;
import com.neogls.prism.central.vaadin.view.stats.event.ReportEventSimple;
import com.neogls.prism.central.vaadin.view.stats.patrol.StatisticReportSimple;
import com.neogls.prism.central.vaadin.view.stats.rapport.RapportSyntheseInterventionAgentView;
import com.neogls.prism.central.vaadin.view.stats.rapport.RapportSynthesePatrouilleViseeView;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.SchemaRoutierSearchView;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.historique.SchemaRoutierHistorique;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dialog.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MenuService {
    private final ConfigurationService configurationService;
    private final SecurityService securityService;
    private final ViewAccessCheckerService viewAccessCheckerService;
    private final ChangePasswordService changePasswordService;
    private final BusinessModuleService businessModuleService;
    private final AtomicReference<Object> userMenu = new AtomicReference();
    private final AtomicReference<Object> adminMenu = new AtomicReference();
    private final AtomicReference<Object> allMenuItems = new AtomicReference();
    private final AtomicReference<Object> parentMenuCache = new AtomicReference();
    private final AtomicReference<Object> menuViewCache = new AtomicReference();

    public boolean isDevModeEnabled() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, "prism.devmode").orElse(false);
    }

    public String getClientLogoUrl() {
        return LogoController.Helper.createLogoURL((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.client.file").orElse("logo.png"));
    }

    public Optional<String> getClientLogoLink() {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.client.lien").filter(Predicate.not(String::isBlank));
    }

    public String getPrismLogoLink() {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "logo.prism.lien").filter(Predicate.not(String::isBlank)).orElse("https://neogls.com/prism/notre-solution-prism/");
    }

    public String getBackgroundColor() {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "environnement.color").orElse("#E17023AA");
    }

    public Optional<String> getEnvironmentLabel() {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "environnement.libelle");
    }

    public Optional<String> getEnvironmentLabelColor() {
        return this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "environnement.libelle.color");
    }

    public boolean isSaisieActionActive() {
        return this.configurationService.isSaisieActionActive();
    }

    public Boolean isViewAccessible(Class<? extends Component> viewClass) {
        return this.viewAccessCheckerService.isViewAccessible(viewClass);
    }

    public AuthenticatedUser getAuthenticatedUser() {
        return this.securityService.getAuthenticatedUser();
    }

    public void logout() {
        this.securityService.logout();
    }

    public Dialog createPasswordChangeDialog() {
        return new ChangePasswordDialog(this.changePasswordService);
    }

    private List<PrismMenu> createUserMenu() {
        return List.of(PrismMenu.builder().text("dashboard.title").image("dashboard").viewClass(MctTableauDeBord.class).build(), PrismMenu.builder().text("mct.title").image("patrouillage").children(List.of(PrismMenu.builder().text("mct.title").image("patrouillage").viewClass(MctPatrouillage.class).build(), PrismMenu.builder().text("mct.schema_routier.title").image("patrouillage").viewClass(SchemaRoutierHistorique.class).build())).build(), PrismMenu.builder().text("intervention.title").image("gyro").viewClass(MctIntervention.class).build(), this.createMenuVH(), this.createMenuEntretien(), this.createMenuFauchage(), PrismMenu.builder().text("itineraire.cyclable.title").image("bicycle").viewClass(MctPietonCycle.class).build(), PrismMenu.builder().text("patrimoine.title").image("patrimony").viewClass(MctPatrimoine.class).build(), PrismMenu.builder().text("travauxneufs.title").image("new_construction").viewClass(MctTravauxNeufs.class).build(), this.createMenuExport());
    }

    private PrismMenu createMenuVH() {
        return PrismMenu.builder().text("vh.title").image("vh").children(List.of(PrismMenu.builder().text("vh.suivi.title").image("vh").viewClass(MctVh.class).build(), PrismMenu.builder().text("vh.suivibarreaux.title").image("vh").viewClass(null).build(), PrismMenu.builder().text("vh.suiviesh.title").image("vh").viewClass(null).build(), PrismMenu.builder().text("vh.suiviesvh.title").image("vh").viewClass(null).build(), PrismMenu.builder().text("vh.bulletin.ctcg.title").image("bulletin").viewClass(null).build(), PrismMenu.builder().text("vh.bulletin.global.title").image("bulletin").viewClass(null).build(), PrismMenu.builder().text("vh.bulletin.media.title").image("bulletin").viewClass(null).build(), PrismMenu.builder().text("vh.patrouille.title").image("vh_patrol").viewClass(null).build(), PrismMenu.builder().text("vh.explorateur.title").image("search_doc").viewClass(null).build(), PrismMenu.builder().text("vh.explorateur.media.title").image("search_doc").viewClass(null).build(), PrismMenu.HR, PrismMenu.builder().text("vh.saisieCCH.title").image("vh_saisie").viewClass(SaisieCCH.class).build(), PrismMenu.builder().text("vh.historiqueCCH.title").image("vh_histo").viewClass(VisualisationCCH.class).build(), PrismMenu.builder().text("vh.historiqueTronconVH.title").image("vh_histo").viewClass(null).build(), PrismMenu.builder().text("vh.historiqueBarreauVH.title").image("vh_histo").viewClass(HistoriqueSaisieCCH.class).build())).build();
    }

    private PrismMenu createMenuEntretien() {
        List activites = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(2)).map(ModuleMetier::getParametres).map(MetierCommun::parseActivites).orElse(List.of());
        if (activites.size() > 1) {
            ArrayList<PrismMenu> sousMenus = new ArrayList<PrismMenu>(activites.size());
            for (ActiviteEntretien activite : activites) {
                String label = activite.getLibelle();
                if (label == null || label.isEmpty()) continue;
                sousMenus.add(PrismMenu.builder().text(label, false).image("entretien").viewClass(MctActivites.class, (Object)activite.getCode()).build());
            }
            if (sousMenus.size() == 1) {
                sousMenus.clear();
            }
            return PrismMenu.builder().text("entretien.title").image("entretien").children(List.of(PrismMenu.builder().text("entretien.title.tous").image("entretien").viewClass(MctActivites.class).build(), PrismMenu.builder().text("entretien.title.activites").image("entretien").children(sousMenus).build(), PrismMenu.builder().text("entretien.title").image("entretien").viewClass(null).build())).build();
        }
        return PrismMenu.builder().text("entretien.title").image("entretien").viewClass(MctEntretien.class).build();
    }

    private PrismMenu createMenuFauchage() {
        return PrismMenu.builder().text("fauchage.title").image("fauchage").children(List.of(PrismMenu.builder().text("fauchage.suivi.title").image("tractor").viewClass(MctFauchage.class).build(), PrismMenu.builder().text("stats.fauchageExploitation.title").image("fauchage_schema").viewClass(FauchageExploitationSchemaView.class).build(), PrismMenu.builder().text("stats.fauchageExploitation.historique").image("fauchage_schema").viewClass(FauchageHistorique.class).build(), PrismMenu.builder().text("debroussaillage.title").image("fauchage_deb").viewClass(null).build(), PrismMenu.builder().text("admin.fauchage.passe.centre.title").image("fauchage").viewClass(FauchagePassesParCentreAdminView.class).build(), PrismMenu.builder().text("admin.fauchage.passe.circuit.title").image("fauchage").viewClass(FauchagePassesParCircuitAdminView.class).build())).build();
    }

    private PrismMenu createMenuExport() {
        return PrismMenu.builder().text("export.title").image("export").children(List.of(PrismMenu.builder().text("report.title").image("report").children(List.of(PrismMenu.builder().text("report.ficheEvenement.title").image("report").viewClass(ReportEventSimple.class).build(), PrismMenu.builder().text("report.synthese.intervention.agent.title").image("report").viewClass(RapportSyntheseInterventionAgentView.class).build(), PrismMenu.builder().text("report.explorateur.infos_patrouille.title").image("report").viewClass(MctRecherchePatrouille.class).build(), PrismMenu.builder().text("report.synthese.patrouille.visee.title").image("report").viewClass(RapportSynthesePatrouilleViseeView.class).build(), PrismMenu.builder().text("vh.analysePatrouillesVH.title").image("report").viewClass(AnalysePatrouillesVH.class).build(), PrismMenu.builder().text("report.external.birt.title").image("report").viewClass(null).build())).build(), this.createMenuStats(), PrismMenu.builder().text("logBook.title").image("logbook").viewClass(LogBookSearchView.class).build())).build();
    }

    private PrismMenu createMenuStats() {
        return PrismMenu.builder().text("statistiques.title").image("stats").children(List.of(PrismMenu.builder().text("stats.statistiques.title").image("stats").viewClass(Stats.class).build(), PrismMenu.builder().text("stats.niveauExploitation.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.patrouilles.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.pc.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.interventions.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.accidentologie.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.frequence.patrouille.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.frequence.patrouilleV2.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.exploitation.circuit.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.schema_routier.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.patrouille.semaine.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.tableau.bord.intervention.bilan").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.exploitation.schema_routier.title").image("stats").viewClass(SchemaRoutierSearchView.class).build(), PrismMenu.builder().text("stats.vh.camions.title").image("stats").viewClass(null).build(), PrismMenu.builder().text("stats.patrouilles.simples.title").image("stats").viewClass(StatisticReportSimple.class).build())).build();
    }

    private List<PrismMenu> createAdminMenu() {
        return List.of(PrismMenu.builder().image("config").children(List.of(PrismMenu.builder().text("admin.profile.title").image("profile").viewClass(ProfileAdminView.class).build(), PrismMenu.builder().text("admin.user.title").image("user").viewClass(UserAdminView.class).build(), PrismMenu.builder().text("admin.track.title").image("tracks").viewClass(CircuitAdminView.class).build(), PrismMenu.builder().text("admin.vehicle.title").image("vehicles").viewClass(VehicleAdminView.class).build(), PrismMenu.builder().text("admin.marque.title").image("vehicles_type").viewClass(VehicleTypeAdminView.class).build(), PrismMenu.builder().text("admin.delegation.title").image("region").viewClass(DelegationAdminView.class).build(), PrismMenu.builder().text("admin.centre.title").image("zone").viewClass(CenterAdminView.class).build(), PrismMenu.builder().text("admin.mail").image("emails").children(List.of(PrismMenu.builder().text("admin.destinataire.title").image("emails_dest").viewClass(MailRecipientAdminView.class).build(), PrismMenu.builder().text("admin.listedestinataire.title").image("emails_list").viewClass(MailListAdminView.class).build(), PrismMenu.builder().text("admin.diffusionevt.title").image("emails_send").viewClass(MailDistributionConfigurationView.class).build())).build(), PrismMenu.builder().text("admin.astreinte.title").image("astreinte").viewClass(null).build(), PrismMenu.builder().text("admin.publication.title").image("publish").viewClass(PublicationConfigurationView.class).build(), PrismMenu.builder().text("admin.configuration.publication.title").image("publish_config").viewClass(PublicationParameterConfigurationAdminView.class).build(), PrismMenu.builder().text("admin.message.alerte.publication.title").image("message").viewClass(AlertMessageAdminView.class).build(), PrismMenu.HR, PrismMenu.builder().text("admin.events.title").image("events").viewClass(EventTypeAdminView.class).build(), PrismMenu.builder().text("admin.components.title").image("components").viewClass(ComponentsAdminView.class).build(), PrismMenu.builder().text("admin.configuration.title").image("configuration").viewClass(null).build(), PrismMenu.HR, PrismMenu.builder().text("admin.test.title").image("draft").viewClass(null).build())).build());
    }

    private List<PrismMenu> createAllMenuItems() {
        return ListUtils.concat((List)this.getUserMenu(), (List)this.getAdminMenu()).stream().flatMap(StreamUtils.flattenRecursive(PrismMenu::getChildren)).filter(prismMenu -> prismMenu != PrismMenu.HR).toList();
    }

    private Map<PrismMenu, PrismMenu> createParentMenuCache() {
        return this.getAllMenuItems().stream().flatMap(prismMenu -> prismMenu.getChildren().stream().filter(subMenu -> subMenu != PrismMenu.HR).map(subMenu -> Map.entry(subMenu, prismMenu))).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<Class<?>, PrismMenu> createMenuViewCache() {
        return this.getAllMenuItems().stream().filter(prismMenu -> prismMenu.getViewClass() != null).filter(subMenu -> subMenu.getParameter() == null).collect(Collectors.toUnmodifiableMap(PrismMenu::getViewClass, Function.identity()));
    }

    @Generated
    public MenuService(ConfigurationService configurationService, SecurityService securityService, ViewAccessCheckerService viewAccessCheckerService, ChangePasswordService changePasswordService, BusinessModuleService businessModuleService) {
        this.configurationService = configurationService;
        this.securityService = securityService;
        this.viewAccessCheckerService = viewAccessCheckerService;
        this.changePasswordService = changePasswordService;
        this.businessModuleService = businessModuleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public List<PrismMenu> getUserMenu() {
        Object $value = this.userMenu.get();
        if ($value == null) {
            AtomicReference atomicReference = this.userMenu;
            synchronized (atomicReference) {
                $value = this.userMenu.get();
                if ($value == null) {
                    List actualValue = this.createUserMenu();
                    $value = actualValue == null ? this.userMenu : actualValue;
                    this.userMenu.set($value);
                }
            }
        }
        return $value == this.userMenu ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public List<PrismMenu> getAdminMenu() {
        Object $value = this.adminMenu.get();
        if ($value == null) {
            AtomicReference atomicReference = this.adminMenu;
            synchronized (atomicReference) {
                $value = this.adminMenu.get();
                if ($value == null) {
                    List actualValue = this.createAdminMenu();
                    $value = actualValue == null ? this.adminMenu : actualValue;
                    this.adminMenu.set($value);
                }
            }
        }
        return $value == this.adminMenu ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public List<PrismMenu> getAllMenuItems() {
        Object $value = this.allMenuItems.get();
        if ($value == null) {
            AtomicReference atomicReference = this.allMenuItems;
            synchronized (atomicReference) {
                $value = this.allMenuItems.get();
                if ($value == null) {
                    List actualValue = this.createAllMenuItems();
                    $value = actualValue == null ? this.allMenuItems : actualValue;
                    this.allMenuItems.set($value);
                }
            }
        }
        return $value == this.allMenuItems ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<PrismMenu, PrismMenu> getParentMenuCache() {
        Object $value = this.parentMenuCache.get();
        if ($value == null) {
            AtomicReference atomicReference = this.parentMenuCache;
            synchronized (atomicReference) {
                $value = this.parentMenuCache.get();
                if ($value == null) {
                    Map actualValue = this.createParentMenuCache();
                    $value = actualValue == null ? this.parentMenuCache : actualValue;
                    this.parentMenuCache.set($value);
                }
            }
        }
        return $value == this.parentMenuCache ? null : $value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public Map<Class<?>, PrismMenu> getMenuViewCache() {
        Object $value = this.menuViewCache.get();
        if ($value == null) {
            AtomicReference atomicReference = this.menuViewCache;
            synchronized (atomicReference) {
                $value = this.menuViewCache.get();
                if ($value == null) {
                    Map actualValue = this.createMenuViewCache();
                    $value = actualValue == null ? this.menuViewCache : actualValue;
                    this.menuViewCache.set($value);
                }
            }
        }
        return $value == this.menuViewCache ? null : $value;
    }
}

