/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.geolocsystems.prismandroid.model.Version;
import com.geolocsystems.prismcentral.Constantes;
import com.neogls.prism.central.vaadin.layout.MenuService;
import com.neogls.prism.central.vaadin.layout.PrismMenu;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialog;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialogService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.SvgIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.spring.security.AuthenticationContext;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Menu
extends HorizontalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Menu.class);
    private static final String LUMO_SPACE_XS = "var(--lumo-space-xs)";
    private static final String LUMO_SPACE_S = "var(--lumo-space-s)";
    private static final String PRISM_MENU_SELECTION_CLASS_NAME = "prism-menu-selected";
    private static final String PRISM_MENU_ITEM_CLASS_NAME = "prism-menu-item";
    private final MenuBar navigationMenuBar = new MenuBar();
    private final MenuBar userActionsMenuBar = new MenuBar();
    private final MenuService menuService;
    private final AddActionDialogService addActionservice;
    private final AuthenticationContext authenticationContext;
    private final Map<PrismMenu, Boolean> accessCache;
    private final Map<PrismMenu, MenuItem> menuEntries = new HashMap();
    private final boolean devMode;

    public Menu(MenuService menuService, AuthenticationContext authenticationContext, AddActionDialogService addActionService) {
        this.menuService = menuService;
        this.authenticationContext = authenticationContext;
        this.addActionservice = addActionService;
        this.devMode = menuService.isDevModeEnabled();
        this.accessCache = this.buildAccessCache();
        this.buildNavigationMenuBar();
        this.buildUserActionsMenuBar();
        this.setWidthFull();
        this.add(new Component[]{this.navigationMenuBar, this.userActionsMenuBar});
        this.setSpacing(false);
        this.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        this.getStyle().set("background-color", menuService.getBackgroundColor());
        this.addClassName("prism-navigation-menu");
    }

    private Map<PrismMenu, Boolean> buildAccessCache() {
        HashMap tmpAccessCache = new HashMap();
        for (PrismMenu prismMenu : this.menuService.getUserMenu()) {
            this.fillAccessCache(tmpAccessCache, prismMenu);
        }
        for (PrismMenu prismMenu : this.menuService.getAdminMenu()) {
            this.fillAccessCache(tmpAccessCache, prismMenu);
        }
        return Collections.unmodifiableMap(tmpAccessCache);
    }

    /*
     * Unable to fully structure code
     */
    private void fillAccessCache(Map<PrismMenu, Boolean> tmpAccessCache, PrismMenu prismMenu) {
        block4: {
            block3: {
                if (prismMenu.getViewClass() == null) break block3;
                tmpAccessCache.put(prismMenu, this.menuService.isViewAccessible(prismMenu.getViewClass()));
                break block4;
            }
            for (PrismMenu child : prismMenu.getChildren()) {
                this.fillAccessCache(tmpAccessCache, child);
            }
            if (this.devMode) ** GOTO lbl-1000
            if (prismMenu.getChildren().stream().anyMatch((Predicate<PrismMenu>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, get(java.lang.Object ), (Lcom/neogls/prism/central/vaadin/layout/PrismMenu;)Z)(tmpAccessCache))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            tmpAccessCache.put(prismMenu, v0);
        }
    }

    private void buildNavigationMenuBar() {
        this.navigationMenuBar.addThemeName("prism-navigation-menu-bar");
        this.navigationMenuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_ICON});
        this.navigationMenuBar.addThemeName("no-checkmark");
        this.navigationMenuBar.addClassName("overflow-auto");
        this.navigationMenuBar.addClassName("ml-s");
        this.navigationMenuBar.addClassName("mt-s");
        this.navigationMenuBar.addClassName("mb-0");
        this.navigationMenuBar.setOpenOnHover(true);
        for (PrismMenu prismMenu : this.menuService.getUserMenu()) {
            this.createMenuItem(prismMenu, (HasMenuItems)this.navigationMenuBar);
        }
    }

    private void buildUserActionsMenuBar() {
        this.userActionsMenuBar.addThemeName("prism-navigation-menu-bar");
        this.userActionsMenuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_ICON});
        this.userActionsMenuBar.addThemeName("no-checkmark");
        this.userActionsMenuBar.addClassName("overflow-auto");
        this.userActionsMenuBar.getStyle().set("margin-right", LUMO_SPACE_S);
        this.userActionsMenuBar.getStyle().set("margin-top", LUMO_SPACE_S);
        this.userActionsMenuBar.getStyle().set("margin-bottom", "0");
        this.userActionsMenuBar.setOpenOnHover(true);
        for (PrismMenu prismMenu : this.menuService.getAdminMenu()) {
            this.createMenuItem(prismMenu, (HasMenuItems)this.userActionsMenuBar);
        }
        if (this.menuService.isSaisieActionActive()) {
            Component commentImage = this.createMenuIconSvg("comment");
            MenuItem myCommentItem = this.userActionsMenuBar.addItem(commentImage, (ComponentEventListener & Serializable)e -> new AddActionDialog(this.addActionservice, null).open());
            myCommentItem.addClassName(PRISM_MENU_ITEM_CLASS_NAME);
            myCommentItem.addClassName("icon-alone");
        }
        this.createUserInformationMenu();
        this.createAboutMenu();
    }

    private void createUserInformationMenu() {
        AuthenticatedUser user = this.menuService.getAuthenticatedUser();
        String name = user.getPrismUser().getNom();
        String delegation = user.getDelegation() == null ? this.getTranslation("login.current.nodelegation", new Object[0]) : this.getTranslation("global.delegation", new Object[0]) + " : " + user.getDelegation();
        String centre = user.getCentre() == null ? this.getTranslation("login.current.nocentre", new Object[0]) : this.getTranslation("global.centre", new Object[0]) + " : " + user.getCentre();
        String profil = this.getTranslation("login.current.profil", new Object[0]) + " : " + user.getProfil().getName();
        Component myAccountImage = this.createMenuIconSvg("my_profile");
        MenuItem myAccountItem = this.userActionsMenuBar.addItem(myAccountImage);
        myAccountItem.add(new Component[]{new Span(name)});
        myAccountItem.addClassName(PRISM_MENU_ITEM_CLASS_NAME);
        SubMenu myAccountSubMenu = (SubMenu)myAccountItem.getSubMenu();
        MenuItem nameItem = (MenuItem)myAccountSubMenu.addItem((Component)new Html(Jsoup.clean((String)("<span>" + name + "</span>"), (Safelist)Safelist.basic())));
        nameItem.addClassName("name-admin");
        nameItem.setEnabled(false);
        MenuItem infosItem = (MenuItem)myAccountSubMenu.addItem((Component)new Html(Jsoup.clean((String)("<ul><li>" + delegation + "</li><li>" + centre + "</li><li>" + profil + "</li></ul>"), (Safelist)Safelist.basic())));
        infosItem.addClassName("list-admin");
        infosItem.setEnabled(false);
        myAccountSubMenu.add(new Component[]{new Hr()});
        MenuItem passwordItem = myAccountSubMenu.addItem(this.createMenuIconSvg("password"), (ComponentEventListener & Serializable)event -> this.menuService.createPasswordChangeDialog().open());
        passwordItem.add(this.getTranslation("admin.user.changePassword", new Object[0]));
        MenuItem logoutItem = myAccountSubMenu.addItem(this.createMenuIconSvg("logout"), (ComponentEventListener & Serializable)event -> {
            this.menuService.logout();
            this.authenticationContext.logout();
        });
        logoutItem.add(this.getTranslation("login.logout", new Object[0]));
    }

    private void createAboutMenu() {
        Component aboutImage = this.createMenuIconSvg("about");
        MenuItem aboutItem = this.userActionsMenuBar.addItem(aboutImage);
        aboutItem.addClassName(PRISM_MENU_ITEM_CLASS_NAME);
        Optional labelStr = this.menuService.getEnvironmentLabel();
        if (labelStr.isPresent()) {
            Span label = new Span((String)labelStr.get());
            this.menuService.getEnvironmentLabelColor().ifPresent(arg_0 -> ((Style)label.getStyle()).setColor(arg_0));
            aboutItem.add(new Component[]{label});
        } else {
            aboutItem.addClassName("icon-alone");
        }
        SubMenu aboutSubMenu = (SubMenu)aboutItem.getSubMenu();
        Image logoPrism = new Image("images/logos/Logo-PRISM.png", "PRISM");
        logoPrism.setWidth(140.0f, Unit.PIXELS);
        Anchor linkLogoPrism = new Anchor(this.menuService.getPrismLogoLink(), new Component[0]);
        linkLogoPrism.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        linkLogoPrism.add(new Component[]{logoPrism});
        linkLogoPrism.getStyle().setDisplay(Style.Display.FLEX);
        Version prismVersion = Constantes.VERSION_CENTRAL;
        String betaRelease = " B\u00e9ta 27";
        Span versionLabel = new Span("Version " + prismVersion + betaRelease);
        versionLabel.setWidthFull();
        versionLabel.getStyle().setFontWeight(Style.FontWeight.BOLD).setColor("#374C5F").setTextAlign(Style.TextAlign.CENTER);
        Image logoClient = new Image(this.menuService.getClientLogoUrl(), "Client");
        logoClient.setWidth(140.0f, Unit.PIXELS);
        Anchor linkLogoClient = new Anchor();
        this.menuService.getClientLogoLink().ifPresent(arg_0 -> ((Anchor)linkLogoClient).setHref(arg_0));
        linkLogoClient.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        linkLogoClient.add(new Component[]{logoClient});
        linkLogoClient.getStyle().setDisplay(Style.Display.FLEX);
        VerticalLayout aboutSubMenuContent = new VerticalLayout(new Component[]{linkLogoPrism, versionLabel, new Hr(), linkLogoClient});
        aboutSubMenuContent.setSpacing(false);
        aboutSubMenuContent.setPadding(false);
        aboutSubMenuContent.addClassNames(new String[]{"px-m", "py-s"});
        aboutSubMenu.add(new Component[]{aboutSubMenuContent});
    }

    private void createMenuItem(PrismMenu prismMenu, HasMenuItems parent) {
        MenuItem menu;
        if (prismMenu == PrismMenu.HR && parent instanceof SubMenu) {
            SubMenu subMenu = (SubMenu)parent;
            subMenu.add(new Component[]{new Hr()});
            return;
        }
        if (!((Boolean)this.accessCache.get(prismMenu)).booleanValue()) {
            return;
        }
        Component image = this.createMenuIconSvg(prismMenu.getImage());
        Span text = this.createMenuSpan(prismMenu);
        if (image != null) {
            menu = parent.addItem(image, this.createMenuItemClickListener(prismMenu));
            if (text.getText().isEmpty()) {
                menu.addClassName("icon-alone");
            } else {
                menu.add(new Component[]{text});
            }
        } else {
            menu = parent.addItem((Component)text, this.createMenuItemClickListener(prismMenu));
        }
        if (parent instanceof SubMenu) {
            menu.getElement().getStyle().set("padding-left", LUMO_SPACE_XS);
        }
        menu.setCheckable(false);
        if (prismMenu == this.getRealTarget(prismMenu)) {
            List children = prismMenu.getChildren();
            int childrenCount = children.size();
            for (int i = 0; i < childrenCount; ++i) {
                PrismMenu child = (PrismMenu)children.get(i);
                if (PrismMenu.HR == child) {
                    if (children.subList(i, childrenCount).stream().noneMatch(this.accessCache::get)) break;
                }
                this.createMenuItem(child, (HasMenuItems)menu.getSubMenu());
            }
        }
        this.menuEntries.put(prismMenu, menu);
        menu.addClassName(PRISM_MENU_ITEM_CLASS_NAME);
    }

    private ComponentEventListener<ClickEvent<MenuItem>> createMenuItemClickListener(PrismMenu prismMenu) {
        PrismMenu realTarget = this.getRealTarget(prismMenu);
        if (realTarget.getViewClass() == null) {
            return (ComponentEventListener & Serializable)event -> {};
        }
        return (ComponentEventListener & Serializable)event -> ((MenuItem)event.getSource()).getUI().ifPresent(ui -> {
            if (realTarget.getParameter() == null) {
                ui.navigate(realTarget.getViewClass());
            } else {
                ui.navigate(realTarget.getViewClass(), HasUrlParameterFormat.getParameters((Object)realTarget.getParameter()));
            }
        });
    }

    private PrismMenu getRealTarget(PrismMenu prismMenu) {
        if (prismMenu.getViewClass() != null) {
            return prismMenu;
        }
        List<PrismMenu> children = prismMenu.getChildren().stream().filter(this.accessCache::get).toList();
        if (children.size() == 1) {
            return this.getRealTarget(children.get(0));
        }
        return prismMenu;
    }

    private Component createMenuIconSvg(String iconName) {
        Image icon;
        if (iconName == null) {
            return null;
        }
        String iconURL = "images/menuV2/" + iconName + ".svg";
        if (this.getClass().getResource("/META-INF/resources/" + iconURL) == null) {
            iconURL = "images/menu/" + iconName + ".png";
            icon = new Image(iconURL, null);
        } else {
            SvgIcon svgIcon = new SvgIcon(iconURL);
            svgIcon.setColor("black");
            icon = svgIcon;
        }
        log.debug("Icon URL: {}", (Object)iconURL);
        return icon;
    }

    private Span createMenuSpan(PrismMenu prismMenu) {
        String text = prismMenu.getText();
        if (text != null) {
            return new Span(prismMenu.isI18nKey() ? this.getTranslation(text, new Object[0]) : text);
        }
        return new Span();
    }

    public void setCurrentView(Class<?> currentView) {
        this.menuEntries.values().forEach(menuItem -> menuItem.removeClassName(PRISM_MENU_SELECTION_CLASS_NAME));
        LinkedList<PrismMenu> stack = new LinkedList<PrismMenu>();
        PrismMenu menu = (PrismMenu)this.menuService.getMenuViewCache().get(currentView);
        if (menu == null) {
            log.warn("The current view is not in the menu");
            return;
        }
        stack.push(menu);
        while (this.menuService.getParentMenuCache().containsKey(stack.getFirst())) {
            stack.push((PrismMenu)this.menuService.getParentMenuCache().get(stack.getFirst()));
        }
        stack.stream().map(this.menuEntries::get).filter(Objects::nonNull).forEach(menuItem -> menuItem.addClassName(PRISM_MENU_SELECTION_CLASS_NAME));
    }
}

