/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.geolocsystems.prism.localisation.CartojCartoService;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import gls.localisation.LocalisationInfo;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Circle;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.MultiPolygon;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.MultiPolyline;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.PathOptions;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.structure.LatLngArray;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.structure.MultiLatLngArray;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class LocalisationSearch
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    private static final String COULEUR_SELECTION_AXE = "#16A900";
    private static final String COULEUR_SELECTION_COMMUNE = "#FF0000";
    private ComboBox cbDepartement;
    private Button rechercheDepartement;
    private ComboBox cbCommune;
    private Button rechercheCommune;
    private ComboBox cbAxe;
    private Button rechercheAxe;
    private ComboBox cbPr;
    private Button recherchePr;
    private ComboBox cbAdresse;
    private Button rechercheAdresse;
    private ComboBox cbNumero;
    private Button rechercheNumero;
    private boolean notifyChanged = true;
    private LeafletMap map;
    private ICartoService cartoService;
    private Button open;
    private Button clear;
    private Button pointDebut;
    private Button legend;
    private Span astreintesCommunes;
    private HorizontalLayout buttonsLayout;
    private VerticalLayout searchLayout;
    private Image imgRechercher;
    private LayerGroup rechercheLayerGroup;
    private Map<String, Layer> rechercheLayersMap;

    public LocalisationSearch(LeafletMap map) {
        this.map = map;
        this.cartoService = BusinessServiceFactory.getCartoService();
        this.rechercheLayerGroup = new LayerGroup(new Layer[0]);
        this.rechercheLayersMap = new HashMap();
        this.setSizeUndefined();
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.setPadding(false);
        this.createUI();
    }

    private void createUI() {
        VerticalLayout searchLayout = new VerticalLayout();
        searchLayout.setSpacing(true);
        searchLayout.add(new Component[]{this.createForm()});
        searchLayout.add(new Component[]{this.createFormAdresseNumero()});
        searchLayout.setSizeUndefined();
        searchLayout.setWidth(100.0f, Unit.PERCENTAGE);
        searchLayout.setPadding(false);
        this.add(new Component[]{searchLayout});
    }

    protected void effacerDonnees(boolean effacerLayers) {
        if (this.cbCommune != null) {
            this.cbCommune.setValue(null);
        }
        if (this.cbAxe != null) {
            this.cbAxe.setValue(null);
        }
        if (this.cbPr != null) {
            this.cbPr.setValue(null);
        }
        if (effacerLayers) {
            this.rechercheLayersMap.keySet().forEach(arg_0 -> this.effacerLayers(arg_0));
            this.rechercheLayerGroup.remove();
        }
    }

    protected Circle createPointFeature(String id, double lon, double lat) {
        Circle feature = new Circle(new LatLng(lat, lon), 5.0);
        PathOptions style = new PathOptions();
        style.setColor(COULEUR_SELECTION_COMMUNE);
        style.setWeight(8.0);
        style.setFill(true);
        feature.setStyle(style);
        feature.setAttribution(id);
        return feature;
    }

    protected final Component createForm() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setMargin(false);
        layout.setSpacing(true);
        this.imgRechercher = new Image("images/menu/rechercher.png", "Recherche");
        if (LocalisationInfo.aCoucheDepartement) {
            layout.add(new Component[]{this.createRechercheDepartement()});
        }
        layout.add(new Component[]{this.createRechercheCommune()});
        if (LocalisationInfo.estLocalisableParPrpk) {
            layout.add(new Component[]{this.createRechercheAxe()});
        }
        this.clear = new Button("Effacer");
        this.clear.setVisible(true);
        this.clear.addClickListener((ComponentEventListener & Serializable)event -> this.effacerDonnees(true));
        layout.add(new Component[]{this.clear});
        layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.clear});
        if (this.aAstreinteCommune()) {
            Component c = this.createFormAstreintes();
            layout.add(new Component[]{c});
            layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{c});
        }
        return layout;
    }

    protected final Component createFormAdresseNumero() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.add(new Component[]{this.createRechercheAdresse()});
        layout.setVisible(LocalisationInfo.estLocalisableParAdresse);
        return layout;
    }

    private boolean aAstreinteCommune() {
        Map m = BusinessServiceFactory.getBusinessService().getAstreintesCommune();
        return m != null && !m.isEmpty();
    }

    private void remplirAstreinteCommune(String commune) {
        StringBuffer sb = new StringBuffer();
        List astreintes = (List)BusinessServiceFactory.getBusinessService().getAstreintesCommune().get(commune);
        if (!GLS.estVide((List)astreintes)) {
            for (String astreinte : astreintes) {
                String[] s = GLS.getTableauString((String)astreinte, (String)" : ");
                sb.append(s[0]);
                sb.append(" : ");
                sb.append("<font color=\"red\">");
                sb.append(s[1]);
                sb.append("</font>");
                sb.append("<br>");
            }
            sb.append("Commune : " + commune);
            this.astreintesCommunes.setText(sb.toString());
        } else {
            this.astreintesCommunes.setText("");
        }
    }

    protected final Component createFormAstreintes() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth(100.0f, Unit.PERCENTAGE);
        layout.setMargin(false);
        layout.setSpacing(true);
        this.astreintesCommunes = new Span();
        this.astreintesCommunes.addClassName("astreinte-title");
        this.astreintesCommunes.setWidth(100.0f, Unit.PERCENTAGE);
        layout.add(new Component[]{this.astreintesCommunes});
        return layout;
    }

    private Component createRechercheDepartement() {
        this.cbDepartement = new ComboBox(this.getTranslation("recherche.departement.label", new Object[0]));
        this.cbDepartement.setEnabled(false);
        this.cbDepartement.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.cbDepartement.getValue() != null) {
                this.notificationSelectionDepartement((String)this.cbDepartement.getValue());
            }
        });
        this.remplirCombo(this.cbDepartement, this.cartoService.getListeDepartement());
        this.rechercheDepartement = new Button();
        Image imgRechercher2 = new Image("images/menu/rechercher.png", "Recherche");
        this.rechercheDepartement.setIcon((Component)imgRechercher2);
        this.rechercheDepartement.addClickListener((ComponentEventListener & Serializable)event -> this.notificationSelectionCommune((String)this.cbDepartement.getValue()));
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.add(new Component[]{this.cbDepartement});
        layout.add(new Component[]{this.rechercheDepartement});
        layout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.rechercheDepartement});
        return layout;
    }

    private Component createRechercheCommune() {
        this.cbCommune = new ComboBox(this.getTranslation("recherche.commune.label", new Object[0]));
        this.cbCommune.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.cbCommune.getValue() != null) {
                this.notificationSelectionCommune((String)this.cbCommune.getValue());
            } else {
                this.remplirCombo(this.cbAxe, this.cartoService.getListeAxe());
            }
        });
        this.remplirCombo(this.cbCommune, this.cartoService.getListeCommune());
        this.rechercheCommune = new Button();
        this.rechercheCommune.setIcon((Component)new Image("images/menu/rechercher.png", "Rechercher"));
        this.rechercheCommune.addClickListener((ComponentEventListener & Serializable)event -> this.notificationSelectionCommune((String)this.cbCommune.getValue()));
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.add(new Component[]{this.cbCommune});
        layout.add(new Component[]{this.rechercheCommune});
        layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.rechercheCommune});
        return layout;
    }

    private Component createRechercheAxe() {
        this.cbAxe = new ComboBox(this.getTranslation("recherche.axe.label", new Object[0]));
        this.rechercheAxe = new Button();
        this.rechercheAxe.setIcon((Component)this.imgRechercher);
        this.rechercheAxe.addClickListener((ComponentEventListener & Serializable)event -> {
            if (this.cbAxe.getValue() != null) {
                this.notificationSelectionAxe((String)this.cbAxe.getValue());
            }
        });
        this.cbAxe.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (this.cbAxe.getValue() != null) {
                this.notificationSelectionAxe((String)this.cbAxe.getValue());
            }
        });
        this.cbPr = new ComboBox(this.getTranslation("recherche.pr.label", new Object[0]));
        this.cbPr.setEnabled(false);
        this.recherchePr = new Button();
        this.recherchePr.setIcon((Component)new Image("images/menu/rechercher.png", "Rechercher"));
        this.recherchePr.setEnabled(false);
        this.recherchePr.addClickListener((ComponentEventListener & Serializable)event -> this.zoomerPr(this.cbDepartement != null ? (String)this.cbDepartement.getValue() : null, (String)this.cbPr.getValue(), (String)this.cbAxe.getValue()));
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.add(new Component[]{this.cbAxe});
        layout.add(new Component[]{this.rechercheAxe});
        layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.rechercheAxe});
        layout.add(new Component[]{this.cbPr});
        layout.add(new Component[]{this.recherchePr});
        layout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.recherchePr});
        this.remplirCombo(this.cbAxe, this.cartoService.getListeAxe());
        return layout;
    }

    private Component createRechercheAdresse() {
        this.cbAdresse = new ComboBox(this.getTranslation("recherche.adresse.label", new Object[0]));
        this.cbAdresse.setEnabled(false);
        this.cbAdresse.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (!GLS.estVide((String)GLS.getString((Object)this.cbCommune.getValue()))) {
                this.notificationSelectionAdresse((String)this.cbCommune.getValue(), (String)this.cbAdresse.getValue());
            }
        });
        this.rechercheAdresse = new Button();
        this.rechercheAdresse.setIcon((Component)this.imgRechercher);
        this.rechercheAdresse.setEnabled(false);
        this.rechercheAdresse.addClickListener((ComponentEventListener & Serializable)event -> this.notificationSelectionAdresse((String)this.cbCommune.getValue(), (String)this.cbAdresse.getValue()));
        this.cbNumero = new ComboBox(this.getTranslation("recherche.numero.label", new Object[0]));
        this.cbNumero.setEnabled(false);
        this.rechercheNumero = new Button();
        this.rechercheNumero.setIcon((Component)this.imgRechercher);
        this.rechercheNumero.setEnabled(false);
        this.rechercheNumero.addClickListener((ComponentEventListener & Serializable)event -> {
            if (!(GLS.estVide((String)GLS.getString((Object)this.cbCommune.getValue())) || GLS.estVide((String)GLS.getString((Object)this.cbAdresse.getValue())) || GLS.estVide((String)GLS.getString((Object)this.cbNumero.getValue())))) {
                this.notificationSelectionNumero((String)this.cbCommune.getValue(), (String)this.cbAdresse.getValue(), (String)this.cbNumero.getValue());
            }
        });
        HorizontalLayout layout = new HorizontalLayout();
        layout.add(new Component[]{this.cbAdresse});
        layout.add(new Component[]{this.cbNumero});
        layout.add(new Component[]{this.rechercheNumero});
        layout.setAlignItems(FlexComponent.Alignment.END);
        return layout;
    }

    protected void notificationSelectionCommune(String commune) {
        if (this.notifyChanged) {
            this.zoomerCommune((String)this.cbCommune.getValue());
        }
        if (LocalisationInfo.estLocalisableParAdresse) {
            Vector vAdresse = this.cartoService.getListeAdresse(commune);
            this.remplirCombo(this.cbAdresse, vAdresse);
            this.cbAdresse.setEnabled(true);
            this.rechercheAdresse.setEnabled(true);
        }
        List axesTest = ((CartojCartoService)this.cartoService).getListeAxe(commune);
        axesTest = axesTest.stream().distinct().toList();
        String[] listeAxes = LocalisationInfo.getAxesCommune((String)commune);
        if (!GLS.estVide(axesTest)) {
            this.remplirCombo(this.cbAxe, axesTest.toArray(new String[0]));
        } else if (!GLS.estVide((String[])listeAxes)) {
            this.remplirCombo(this.cbAxe, listeAxes);
        } else {
            this.remplirCombo(this.cbAxe, this.cartoService.getListeAxe());
        }
        if (this.aAstreinteCommune()) {
            this.remplirAstreinteCommune(commune);
        }
    }

    private void remplirCombo(ComboBox combo, Vector liste) {
        combo.clear();
        if (liste != null) {
            combo.setItems((Collection)liste);
        }
    }

    private void remplirCombo(ComboBox combo, String[] liste) {
        combo.clear();
        if (liste != null) {
            combo.setItems((Object[])liste);
        }
    }

    private void notificationSelectionAxe(String axe) {
        if (this.notifyChanged) {
            this.zoomerAxe(axe);
        }
        Vector vPr = null;
        vPr = this.cbCommune.getValue() != null ? this.cartoService.getListePR(this.cbCommune.getValue().toString(), axe) : this.cartoService.getListePR(axe);
        this.remplirCombo(this.cbPr, vPr);
        if (this.cbDepartement != null) {
            this.cbDepartement.setEnabled(true);
        }
        this.cbPr.setEnabled(true);
        this.recherchePr.setEnabled(true);
    }

    protected void notificationSelectionAdresse(String commune, String adresse) {
        Vector vNuemro = this.cartoService.getListeNumero(commune, adresse);
        this.remplirCombo(this.cbNumero, vNuemro);
        this.cbNumero.setEnabled(true);
        this.rechercheNumero.setEnabled(true);
    }

    protected void notificationSelectionNumero(String commune, String adresse, String numero) {
        Double[] bounds = this.cartoService.getNumeroBounds(commune, adresse, numero);
        if (bounds != null) {
            this.effacerLayers("numero");
            this.map.flyTo(new LatLng(bounds[1].doubleValue(), bounds[0].doubleValue()));
            Circle f = this.createPointFeature(numero, bounds[0].doubleValue(), bounds[1].doubleValue());
            f.addTo(this.rechercheLayerGroup);
            this.rechercheLayerGroup.addTo(this.map);
        }
    }

    private void notificationSelectionDepartement(String dpt) {
    }

    private void zoomerCommune(String commune) {
        PathOptions style = new PathOptions();
        style.setColor(COULEUR_SELECTION_COMMUNE);
        style.setWeight(2.0);
        style.setDashArray("2.");
        style.setDashOffset("5.");
        this.effacerLayers("commune");
        if (!GLS.estVide((String)((String)this.cbCommune.getValue()))) {
            List coordonneesCommune = Recherche.getCoordonneesCommune((String)commune);
            this.selectionnerLineaire("commune", this.map, this.rechercheLayerGroup, coordonneesCommune, style, true, true);
        }
    }

    private void zoomerAxe(String axe) {
        PathOptions style = new PathOptions();
        style.setColor(COULEUR_SELECTION_AXE);
        style.setWeight(5.0);
        style.setFill(false);
        if (GLS.estVide((String)((String)this.cbCommune.getValue()))) {
            List coordonneesAxe = Recherche.getCoordonneesRoute((String)axe);
            this.selectionnerLineaire("axe", this.map, this.rechercheLayerGroup, coordonneesAxe, style, true, true);
        } else {
            List coordonneesAxe = Recherche.getCoordonneesRoute((String)axe);
            this.selectionnerLineaire("axe", this.map, this.rechercheLayerGroup, coordonneesAxe, style, false, true);
        }
    }

    private void selectionnerLineaire(String code, LeafletMap map, LayerGroup layerGroup, List<float[][]> coordonneesLineaire, PathOptions style, boolean zoom, boolean effacer) {
        MultiLatLngArray lineLatLng = new MultiLatLngArray();
        for (float[][] f : coordonneesLineaire) {
            try {
                ArrayList<LatLng> points = new ArrayList<LatLng>(f[0].length);
                for (int i = 0; i < f[0].length; ++i) {
                    points.add(new LatLng((double)f[1][i], (double)f[0][i]));
                }
                LatLngArray latLngArray = new LatLngArray(points);
                lineLatLng.add((Object)latLngArray);
            }
            catch (Exception e) {
                Log.error((Object)"", (Throwable)e);
            }
        }
        if (effacer) {
            this.effacerLayers(code);
            layerGroup.remove();
        }
        if (!lineLatLng.isEmpty()) {
            MultiPolyline line;
            if ("commune".equals(code)) {
                MultiPolygon.MultiPolygonStructure structure = new MultiPolygon.MultiPolygonStructure();
                structure.add((Object)lineLatLng);
                line = new MultiPolygon(structure);
            } else {
                line = new MultiPolyline(lineLatLng);
            }
            line.setStyle(style);
            line.setAttribution(code);
            line.addTo(layerGroup);
            layerGroup.addTo(map);
            this.rechercheLayersMap.put(code, line);
            if (zoom) {
                map.flyToBounds(line.getBounds());
            }
        }
    }

    private void zoomerPr(String dpt, String pr, String axe) {
        this.effacerLayers("pr");
        Double[] bounds = null;
        bounds = dpt == null ? this.cartoService.getPrBounds(axe, pr) : this.cartoService.getPrBounds(dpt, axe, pr);
        if (bounds != null) {
            this.map.flyTo(new LatLng(bounds[1].doubleValue(), bounds[0].doubleValue()));
            this.effacerLayers("pr");
            this.rechercheLayerGroup.remove();
            Circle f = this.createPointFeature(axe + pr, bounds[0].doubleValue(), bounds[1].doubleValue());
            f.addTo(this.rechercheLayerGroup);
            this.rechercheLayerGroup.addTo(this.map);
            this.rechercheLayersMap.put("pr", f);
        }
    }

    private void effacerLayers(String code) {
        Layer l = (Layer)this.rechercheLayersMap.get(code);
        if (l != null) {
            l.remove();
        }
    }

    private void zoomerPr(String pr, String axe) {
        this.effacerLayers("pr");
        Double[] bounds = this.cartoService.getPrBounds(axe, pr);
        if (bounds != null) {
            this.effacerLayers("pr");
            this.rechercheLayerGroup.remove();
            Circle f = this.createPointFeature(axe + pr, bounds[0].doubleValue(), bounds[1].doubleValue());
            f.addTo(this.rechercheLayerGroup);
            this.rechercheLayerGroup.addTo(this.map);
            this.rechercheLayersMap.put("pr", f);
            this.map.flyTo(new LatLng(bounds[1].doubleValue(), bounds[0].doubleValue()));
        }
    }

    protected void zoomZone(double lon, double lat) {
        this.effacerLayers("zone");
        this.map.flyTo(new LatLng(lat, lon));
        Circle f = this.createPointFeature("" + (lon + lat), lon, lat);
        f.addTo(this.rechercheLayerGroup);
        this.rechercheLayerGroup.addTo(this.map);
        this.rechercheLayersMap.put("zone", f);
    }

    public ComboBox getDepartement() {
        return this.cbDepartement;
    }

    public Button getRechercheDepartement() {
        return this.rechercheDepartement;
    }

    public ComboBox getCommune() {
        return this.cbCommune;
    }

    public Button getRechercheCommune() {
        return this.rechercheCommune;
    }

    public ComboBox getAxe() {
        return this.cbAxe;
    }

    public Button getRechercheAxe() {
        return this.rechercheAxe;
    }

    public ComboBox getPr() {
        return this.cbPr;
    }

    public Button getRecherchePr() {
        return this.recherchePr;
    }

    public void notifySelectionChanged(boolean b) {
        this.notifyChanged = b;
    }

    public void deleteLayers() {
    }
}

