/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.ChangePasswordService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import gls.outils.Util;
import jakarta.annotation.Nonnull;
import lombok.Generated;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ChangePasswordService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;

    @Nonnull
    public AuthenticatedUser getCurrentUser() {
        return this.userPermissionService.getCurrentUser();
    }

    @Nonnull
    public PasswordValidationResult validatePasswordComplexity(@Nonnull String password) {
        if (password.isEmpty()) {
            return PasswordValidationResult.error((String)"admin.user.error.pwd");
        }
        if (this.isComplexPasswordRequired()) {
            try {
                Util.isComplexPassword((String)password);
                return PasswordValidationResult.ok();
            }
            catch (Util.ExceptionReglesMotDePasse e) {
                return PasswordValidationResult.error((String)"admin.user.error.pwdrules");
            }
            catch (Util.ExceptionNbCaracteres e) {
                return PasswordValidationResult.error((String)"admin.user.error.pwdnbcar");
            }
        }
        return PasswordValidationResult.ok();
    }

    public boolean updatePassword(String username, String oldPassword, String newPassword) {
        PrismCentralUser user = this.businessService.login(username, oldPassword);
        if (user == null) {
            return false;
        }
        this.businessService.updateUserPassword(username, newPassword, true);
        return true;
    }

    private boolean isComplexPasswordRequired() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "complexPassword").orElse(false);
    }

    @Generated
    public ChangePasswordService(IBusinessService businessService, ConfigurationService configurationService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
    }
}

