/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.layout;

import com.neogls.prism.central.vaadin.layout.ChangePasswordService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Optional;

public class ChangePasswordDialog
extends Dialog {
    private final PasswordField oldPassword = new PasswordField(this.getTranslation("password-change.old-password", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> ((PasswordField)event.getSource()).setInvalid(false));
    private final PasswordField newPassword = new PasswordField(this.getTranslation("password-change.new-password", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> this.validate());
    private final PasswordField confirmPassword = new PasswordField(this.getTranslation("password-change.confirm-password", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> this.validate());
    private final ChangePasswordService service;

    public ChangePasswordDialog(ChangePasswordService service) {
        this.service = service;
        this.setHeaderTitle(this.getTranslation("admin.user.changePassword", new Object[0]));
        this.setCloseOnOutsideClick(false);
        AuthenticatedUser currentUser = service.getCurrentUser();
        TextField username = new TextField(this.getTranslation("admin.user.sna", new Object[0]));
        TextField name = new TextField(this.getTranslation("admin.user.name", new Object[0]));
        username.setReadOnly(true);
        name.setReadOnly(true);
        username.setValue(currentUser.getPrismUser().getCode());
        name.setValue(currentUser.getPrismUser().getNom());
        this.oldPassword.setValueChangeMode(ValueChangeMode.LAZY);
        this.newPassword.setValueChangeMode(ValueChangeMode.LAZY);
        this.confirmPassword.setValueChangeMode(ValueChangeMode.LAZY);
        this.oldPassword.setErrorMessage(this.getTranslation("password-change.error.wrong-password", new Object[0]));
        this.confirmPassword.setErrorMessage(this.getTranslation("admin.user.error.pwddiff", new Object[0]));
        VerticalLayout layout = new VerticalLayout(new Component[]{username, name, this.oldPassword, this.newPassword, this.confirmPassword});
        layout.setPadding(false);
        layout.setSpacing(false);
        layout.setWidth(25.0f, Unit.EM);
        layout.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.add(new Component[]{layout});
        Button buttonSave = new Button(this.getTranslation("admin.save", new Object[0]), (ComponentEventListener & Serializable)event -> this.onButtonSaveClicked());
        buttonSave.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.getFooter().add(new Component[]{new Button(this.getTranslation("admin.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close()), buttonSave});
    }

    private boolean validate() {
        String newPasswordValue = this.newPassword.getValue();
        boolean passwordsMatch = newPasswordValue.equals(this.confirmPassword.getValue());
        this.confirmPassword.setInvalid(!passwordsMatch);
        ChangePasswordService.PasswordValidationResult validationResult = this.service.validatePasswordComplexity(newPasswordValue);
        this.newPassword.setInvalid(!validationResult.isValid());
        this.newPassword.setErrorMessage(Optional.ofNullable(validationResult.getErrorMessage()).map(x$0 -> this.getTranslation(x$0, new Object[0])).orElse(""));
        return passwordsMatch && validationResult.isValid();
    }

    private void onButtonSaveClicked() {
        if (!this.validate()) {
            return;
        }
        if (this.service.updatePassword(this.service.getCurrentUser().getPrismUser().getCode(), this.oldPassword.getValue(), this.newPassword.getValue())) {
            this.close();
        } else {
            this.oldPassword.setInvalid(true);
        }
    }
}

