/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.configuration;

import com.neogls.prism.central.vaadin.common.viewactivation.ViewActivationService;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class UIConfiguration
implements UIInitListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UIConfiguration.class);
    private final ViewActivationService viewActivationService;

    public void uiInit(UIInitEvent event) {
        event.getUI().addBeforeEnterListener(arg_0 -> this.checkForConfigurableActivation(arg_0));
    }

    private void checkForConfigurableActivation(BeforeEnterEvent event) {
        if (!(event.hasRerouteTarget() || event.hasForwardTarget() || this.viewActivationService.isViewActivated(event.getNavigationTarget()))) {
            log.warn("Tried to access {} but this view is not activated", (Object)event.getNavigationTarget().getSimpleName());
            event.rerouteToError(NotFoundException.class);
        }
    }

    @Generated
    public UIConfiguration(ViewActivationService viewActivationService) {
        this.viewActivationService = viewActivationService;
    }
}

