/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.viewactivation;

import com.neogls.prism.central.vaadin.common.viewactivation.ConfigurableActivation;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import jakarta.annotation.security.DenyAll;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ViewActivationService {
    private final ConfigurationService configurationService;

    public boolean isViewActivated(Class<?> viewClass) {
        if (viewClass.isAnnotationPresent(DenyAll.class)) {
            return false;
        }
        ConfigurableActivation activation = viewClass.getAnnotation(ConfigurableActivation.class);
        if (activation == null) {
            return true;
        }
        if (activation.propertyConfigurationBoolean().length != 0) {
            ConfigurableActivation.PropertyConfigurationBoolean propertyConfigurationBoolean = activation.propertyConfigurationBoolean()[0];
            return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.PROPERTY, propertyConfigurationBoolean.name()).orElse(propertyConfigurationBoolean.defaultValue());
        }
        return false;
    }

    @Generated
    public ViewActivationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

