/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.service;

import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.leaflet.PathOptionsBuilder;
import jakarta.annotation.Nullable;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.CircleMarker;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.MultiPolygon;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.MultiPolyline;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;

@Service
public class LeafletRenderService {
    private static final String COULEUR_SELECTION_AXE = "#16A900";
    private static final String COULEUR_SELECTION_COMMUNE = "#FF0000";

    @Nullable
    public Polyline createLayerAxe(List<List<Point>> geometrieAxe) {
        if (geometrieAxe.isEmpty()) {
            return null;
        }
        MultiPolyline multiLine = new MultiPolyline(LeafletUtils.pointMultiListToMultiLatLngArray(geometrieAxe));
        multiLine.setStyle(PathOptionsBuilder.builder().color(COULEUR_SELECTION_AXE).weight(Double.valueOf(5.0)).build().build());
        return multiLine;
    }

    @Nullable
    public Polyline createLayerCommune(List<List<Point>> geometrieCommune) {
        if (geometrieCommune.isEmpty()) {
            return null;
        }
        MultiPolygon.MultiPolygonStructure structure = new MultiPolygon.MultiPolygonStructure();
        structure.add((Object)LeafletUtils.pointMultiListToMultiLatLngArray(geometrieCommune));
        MultiPolygon multiPolygon = new MultiPolygon(structure);
        multiPolygon.setStyle(PathOptionsBuilder.builder().color(COULEUR_SELECTION_COMMUNE).weight(Double.valueOf(2.0)).dashArray("2, 5").fill(true).build().build());
        return multiPolygon;
    }

    @Nullable
    public Layer createLayerPr(@Nullable Point localisationPr) {
        if (localisationPr == null) {
            return null;
        }
        CircleMarker circle = new CircleMarker(LeafletUtils.pointToLatLng((Point)localisationPr), 5.0);
        circle.setStyle(PathOptionsBuilder.builder().color(COULEUR_SELECTION_COMMUNE).fill(true).fillColor(COULEUR_SELECTION_COMMUNE).fillOpacity(Double.valueOf(1.0)).build().build());
        return circle;
    }

    @Generated
    public LeafletRenderService() {
    }
}

