/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.tabsheet;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.shared.Registration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PrismTabSheet
extends Composite<Div>
implements HasSize {
    private final Tabs tabs = new Tabs();
    private final Div tabContentContainer = new Div();
    private final Map<Tab, Component> components = new HashMap();
    private final boolean lazyAttachTabContent;

    public PrismTabSheet() {
        this(false);
    }

    public PrismTabSheet(boolean lazyAttachTabContent) {
        this.lazyAttachTabContent = lazyAttachTabContent;
        this.tabs.addSelectedChangeListener(arg_0 -> this.onSelectedChange(arg_0));
        ((Div)this.getContent()).add(new Component[]{this.tabs, this.tabContentContainer});
        this.addClassName("prism-tabsheet");
        this.tabContentContainer.addClassName("tab-content-container");
    }

    private void onSelectedChange(Tabs.SelectedChangeEvent selectedChangeEvent) {
        if (selectedChangeEvent.getPreviousTab() != null) {
            ((Component)this.components.get(selectedChangeEvent.getPreviousTab())).setVisible(false);
        }
        if (selectedChangeEvent.getSelectedTab() != null) {
            Component tabContent = (Component)this.components.get(selectedChangeEvent.getSelectedTab());
            if (tabContent.isVisible()) {
                this.tabContentContainer.add(new Component[]{tabContent});
            } else {
                tabContent.setVisible(true);
            }
        }
    }

    public Tab add(String name, Component content) {
        return this.addTab(new Tab(name), content);
    }

    public Tab add(Component tabContent, Component content) {
        return this.addTab(new Tab(new Component[]{tabContent}), content);
    }

    public Tab addTab(Tab tab, Component content) {
        this.registerTabContent(tab, content);
        this.tabs.add(new Tab[]{tab});
        return tab;
    }

    public Tab addAtIndex(String name, Component content, int index) {
        return this.addTabAtIndex(new Tab(name), content, index);
    }

    public Tab addAtIndex(Component tabContent, Component content, int index) {
        return this.addTabAtIndex(new Tab(new Component[]{tabContent}), content, index);
    }

    public Tab addTabAtIndex(Tab tab, Component content, int index) {
        this.registerTabContent(tab, content);
        this.tabs.addTabAtIndex(index, tab);
        return tab;
    }

    private void registerTabContent(Tab tab, Component content) {
        this.components.put(tab, content);
        if (!this.lazyAttachTabContent) {
            content.setVisible(false);
            this.tabContentContainer.add(new Component[]{content});
        }
    }

    public void remove(Tab ... tabsToRemove) {
        this.tabs.remove(tabsToRemove);
        Arrays.stream(tabsToRemove).map(this.components::remove).forEach(Component::removeFromParent);
    }

    public void removeAll() {
        this.tabs.removeAll();
        this.components.values().forEach(Component::removeFromParent);
        this.components.clear();
    }

    public Tab getTabAt(int index) {
        return this.tabs.getTabAt(index);
    }

    public Tab getSelectedTab() {
        return this.tabs.getSelectedTab();
    }

    public void setSelectedTab(Tab selectedTab) {
        this.tabs.setSelectedTab(selectedTab);
    }

    public int getSelectedIndex() {
        return this.tabs.getSelectedIndex();
    }

    public void setSelectedIndex(int selectedIndex) {
        this.tabs.setSelectedIndex(selectedIndex);
    }

    public void setAutoselect(boolean autoselect) {
        this.tabs.setAutoselect(autoselect);
    }

    public int getComponentCount() {
        return this.tabs.getComponentCount();
    }

    public Registration addSelectedChangeListener(ComponentEventListener<Tabs.SelectedChangeEvent> listener) {
        return this.tabs.addSelectedChangeListener(listener);
    }
}

