/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.prismintegerfield;

import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasPlaceholder;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.shared.HasClearButton;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import lombok.Generated;

public class PrismIntegerField
extends AbstractCompositeField<TextField, PrismIntegerField, Integer>
implements HasLabel,
HasValidationProperties,
HasPlaceholder,
HasClearButton {
    private int step = 1;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public PrismIntegerField(String label) {
        this();
        this.setLabel(label);
    }

    public PrismIntegerField() {
        super(null);
        ((TextField)this.getContent()).setPattern("^0|-?[1-9]\\d*$");
        ((TextField)this.getContent()).setAllowedCharPattern("[-0-9]");
        this.getElement().executeJs("this.addEventListener('wheel', event => {\n    event.preventDefault();\n    if (event.deltaY < 0) this.$server.increment();\n    if (event.deltaY > 0) this.$server.decrement();\n});\nthis.addEventListener('keydown', event => {\n    if (event.key === \"ArrowUp\") { this.$server.increment(); event.preventDefault(); }\n    if (event.key === \"ArrowDown\") { this.$server.decrement(); event.preventDefault(); }\n});\n", new Serializable[0]);
        ((TextField)this.getContent()).addValueChangeListener(arg_0 -> this.onInputValueChange(arg_0));
        ((TextField)this.getContent()).setClearButtonVisible(true);
    }

    protected void setPresentationValue(Integer newPresentationValue) {
        if (newPresentationValue != null) {
            ((TextField)this.getContent()).setValue(String.valueOf(newPresentationValue));
        } else {
            ((TextField)this.getContent()).clear();
        }
    }

    private void applyValue(int value) {
        if (value < this.min) {
            value = this.min;
        } else if (value > this.max) {
            value = this.max;
        }
        this.setPresentationValue(Integer.valueOf(value));
        this.setModelValue((Object)value, true);
    }

    private void onInputValueChange(HasValue.ValueChangeEvent<String> event) {
        if (!event.isFromClient()) {
            return;
        }
        if (((TextField)this.getContent()).isEmpty()) {
            this.setModelValue(null, true);
        } else {
            int value;
            try {
                value = Integer.parseInt((String)event.getValue());
            }
            catch (NumberFormatException e) {
                ((TextField)this.getContent()).setInvalid(true);
                this.setModelValue(null, true);
                return;
            }
            this.applyValue(value);
        }
    }

    @ClientCallable
    private void increment() {
        this.applyValue(this.getOptionalValue().orElse(0) + this.step);
    }

    @ClientCallable
    private void decrement() {
        this.applyValue(this.getOptionalValue().orElse(0) - this.step);
    }

    @Generated
    public void setStep(int step) {
        this.step = step;
    }

    @Generated
    public void setMin(int min) {
        this.min = min;
    }

    @Generated
    public void setMax(int max) {
        this.max = max;
    }
}

