/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.optional.field;

import com.neogls.prism.central.vaadin.common.component.customfield.PrismCustomField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractOptionalField<T, C extends Component & HasEnabled>
extends PrismCustomField<Optional<T>> {
    private final C field;
    private final Checkbox cbEnabled = new Checkbox();

    protected AbstractOptionalField(C field) {
        super(Optional.empty());
        this.field = field;
        this.cbEnabled.addValueChangeListener(arg_0 -> this.onEnableValueChange(arg_0));
        ((HasValue)field).addValueChangeListener(arg_0 -> this.onFieldValueChange(arg_0));
        ((HasEnabled)field).setEnabled(false);
        this.add(new Component[]{this.cbEnabled, field});
        this.addClassName("optional-field");
        field.addClassName("field");
    }

    private void onEnableValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        ((HasEnabled)this.field).setEnabled(((Boolean)event.getValue()).booleanValue());
    }

    private void onFieldValueChange(HasValue.ValueChangeEvent<T> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    protected Optional<T> generateModelValue() {
        return (Boolean)this.cbEnabled.getValue() != false ? Optional.ofNullable(((HasValue)this.field).getValue()) : Optional.empty();
    }

    protected void setPresentationValue(Optional<T> newPresentationValue) {
        this.cbEnabled.setValue((Object)newPresentationValue.isPresent());
        newPresentationValue.ifPresentOrElse(arg_0 -> ((HasValue)((HasValue)this.field)).setValue(arg_0), () -> ((HasValue)((HasValue)this.field)).clear());
    }

    protected final C getField() {
        return (C)this.field;
    }

    public void setCheckboxLabel(String label) {
        this.cbEnabled.setLabel(label);
        this.setThemeName("has-checkbox-label", StringUtils.isNotBlank((CharSequence)label));
    }
}

