/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.map;

import com.neogls.prism.central.vaadin.common.component.map.InUseEvent;
import com.neogls.prism.central.vaadin.common.component.map.MapComponent;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.events.MouseEvent;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class PathPicker
extends CustomField<List<Point>>
implements MapComponent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathPicker.class);
    private final Button reset = new Button((Component)VaadinIcon.TRASH.create(), arg_0 -> this.onResetClick(arg_0));
    private final Button toggle = new Button();
    private boolean inUse;

    public PathPicker(LeafletMap map) {
        super(List.of());
        this.toggle.setMinWidth(11.0f, Unit.EM);
        this.toggle.addClickListener((ComponentEventListener & Serializable)event -> this.fireEvent((ComponentEvent)new InUseEvent((MapComponent)this, event.isFromClient(), !this.inUse, this.inUse)));
        this.addInUseListener(arg_0 -> this.onInUseEvent(arg_0));
        map.onClick(arg_0 -> this.onMapClick(arg_0));
        FlexLayout content = new FlexLayout(new Component[]{this.toggle, this.reset});
        content.addClassName("gap-s");
        content.setFlexGrow(1.0, new HasElement[]{this.toggle});
        this.add(new Component[]{content});
        this.updateUI();
    }

    private void updateUI() {
        log.debug("updateUI");
        log.debug("inUse: {}", (Object)this.inUse);
        this.toggle.setText(this.inUse ? this.getTranslation("component.path-picker.end", new Object[0]) : this.getTranslation("component.path-picker.draw-on-map", new Object[0]));
    }

    private void onInUseEvent(InUseEvent event) {
        if (event.useChanged()) {
            this.inUse = event.isInUse();
            this.updateUI();
        }
    }

    private void onMapClick(MouseEvent event) {
        if (!this.inUse || !this.isEnabled()) {
            return;
        }
        LinkedList<Point> value = new LinkedList<Point>((Collection)this.getValue());
        value.addLast(LeafletUtils.latLngToPoint((LatLng)event.getLatLng()));
        this.setModelValue(value, event.isFromClient());
    }

    private void onResetClick(ClickEvent<Button> event) {
        this.setModelValue((Object)((List)this.getEmptyValue()), event.isFromClient());
    }

    protected List<Point> generateModelValue() {
        log.warn("`generateModelValue` called");
        return (List)this.getValue();
    }

    protected void setPresentationValue(List<Point> newPresentationValue) {
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.fireEvent((ComponentEvent)new InUseEvent((MapComponent)this, false, inUse, this.inUse));
    }
}

