/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.delegationandcenterfield;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.InputField;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@Tag(value="vaadin-custom-field")
public class DelegationAndCenterField
extends AbstractField<DelegationAndCenterField, DelegationAndCenter>
implements InputField<AbstractField.ComponentValueChangeEvent<DelegationAndCenterField, DelegationAndCenter>, DelegationAndCenter>,
HasThemeVariant<DelegationAndCenterFieldThemeVariant> {
    private final ComboBox<Delegation> delegation = new ComboBox(arg_0 -> this.onDelegationChange(arg_0));
    private final ComboBox<Centre> center = new ComboBox(arg_0 -> this.onCenterChange(arg_0));
    private final Map<String, Delegation> delegationsByName;
    private final Map<String, Centre> centersByName;
    private String delegationPlaceholder = null;

    public DelegationAndCenterField(@Nonnull Collection<Delegation> delegationsAndCenters) {
        super((Object)DelegationAndCenter.empty());
        this.delegationsByName = Maps.uniqueIndex(delegationsAndCenters, Delegation::getNom);
        this.centersByName = Maps.uniqueIndex(this.delegationsByName.values().stream().map(Delegation::getCentres).flatMap(Collection::stream).iterator(), Centre::getNom);
        this.delegation.setItems(this.delegationsByName.values());
        this.center.setItems(this.centersByName.values());
        this.delegation.setClearButtonVisible(true);
        this.center.setClearButtonVisible(true);
        this.getElement().appendChild(new Element[]{this.delegation.getElement(), this.center.getElement()});
        this.addClassName("delegation-and-center-field");
        this.setLabelsVisible(true);
    }

    public DelegationAndCenterField(@Nonnull Collection<Delegation> delegationsAndCenters, @Nonnull HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<DelegationAndCenterField, DelegationAndCenter>> listener) {
        this(delegationsAndCenters);
        this.addValueChangeListener(listener);
    }

    private void onDelegationChange(HasValue.ValueChangeEvent<Delegation> event) {
        if (event.getOldValue() == null && !this.center.isEmpty()) {
            this.delegation.setPlaceholder(this.delegationPlaceholder);
        }
        if (event.getHasValue().isEmpty()) {
            this.center.getListDataView().removeFilters();
        } else {
            this.center.getListDataView().setFilter(((Delegation)event.getValue()).getCentres()::contains);
        }
        if (event.isFromClient()) {
            this.center.clear();
            this.setModelValue((Object)DelegationAndCenter.of((Delegation)((Delegation)event.getValue()), (Centre)((Centre)this.center.getValue())), event.isFromClient());
        }
    }

    private void onCenterChange(HasValue.ValueChangeEvent<Centre> event) {
        if (event.isFromClient()) {
            this.setModelValue((Object)DelegationAndCenter.of((Delegation)((Delegation)this.delegation.getValue()), (Centre)((Centre)event.getValue())), event.isFromClient());
            if (this.delegation.isEmpty()) {
                if (this.center.isEmpty()) {
                    this.delegation.setPlaceholder(this.delegationPlaceholder);
                } else if (event.getOldValue() == null || !((Centre)event.getValue()).getDelegation().equals(((Centre)event.getOldValue()).getDelegation())) {
                    this.delegation.setPlaceholder(((Centre)event.getValue()).getDelegation());
                }
            }
        }
    }

    protected void setPresentationValue(DelegationAndCenter newPresentationValue) {
        this.delegation.setValue((Object)((Delegation)this.delegationsByName.get(newPresentationValue.getDelegation())));
        this.center.setValue((Object)((Centre)this.centersByName.get(newPresentationValue.getCenter())));
    }

    public void setDelegationReadOnly() {
        super.setReadOnly(false);
        this.delegation.setReadOnly(true);
        this.center.setReadOnly(false);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.delegation.setReadOnly(readOnly);
        this.center.setReadOnly(readOnly);
    }

    public void setDelegationPlaceholder(String placeholder) {
        this.delegation.setPlaceholder(placeholder);
        this.delegationPlaceholder = placeholder;
    }

    public void setCenterPlaceholder(String placeholder) {
        this.center.setPlaceholder(placeholder);
    }

    public void setLabelsVisible(boolean labelsVisible) {
        if (labelsVisible) {
            this.delegation.setLabel(this.getTranslation("global.delegation", new Object[0]));
            this.center.setLabel(this.getTranslation("global.centre", new Object[0]));
        } else {
            this.delegation.setLabel(null);
            this.center.setLabel(null);
        }
    }

    public String getLabel() {
        return this.getElement().getProperty("label", null);
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label);
    }

    public static <T> ValueProvider<T, DelegationAndCenter> createGetter(ValueProvider<T, String> delegationGetter, ValueProvider<T, String> centerGetter) {
        Objects.requireNonNull(delegationGetter);
        Objects.requireNonNull(centerGetter);
        return (ValueProvider & Serializable)bean -> new DelegationAndCenter((String)delegationGetter.apply(bean), (String)centerGetter.apply(bean));
    }

    public static <T> Setter<T, DelegationAndCenter> createSetter(Setter<T, String> delegationSetter, Setter<T, String> centerSetter) {
        Objects.requireNonNull(delegationSetter);
        Objects.requireNonNull(centerSetter);
        return (Setter & Serializable)(bean, delegationAndCenter) -> {
            delegationSetter.accept(bean, (Object)delegationAndCenter.getDelegation());
            centerSetter.accept(bean, (Object)delegationAndCenter.getCenter());
        };
    }
}

