/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.datetimepicker;

import com.neogls.prism.central.vaadin.common.component.customfield.PrismCustomField;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;

public class PrismDateTimePicker
extends PrismCustomField<LocalDateTime> {
    private final DatePicker datePicker = new DatePicker(arg_0 -> this.onDateValueChange(arg_0));
    private final TimePicker timePicker = new TimePicker(arg_0 -> this.onTimeValueChange(arg_0));
    private final Button clearButton = new Button((Component)VaadinIcon.CLOSE.create(), arg_0 -> this.onClearButtonClick(arg_0));

    public PrismDateTimePicker() {
        this.datePicker.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.timePicker.setEnabled(false);
        this.datePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.timePicker.setEnabled(!event.getHasValue().isEmpty()));
        this.clearButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_ERROR});
        this.add(new Component[]{this.datePicker, this.timePicker, this.clearButton});
        this.addClassName("prism-date-time-picker");
    }

    private void onDateValueChange(HasValue.ValueChangeEvent<LocalDate> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    private void onTimeValueChange(HasValue.ValueChangeEvent<LocalTime> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    private void onClearButtonClick(ClickEvent<Button> clickEvent) {
        this.setPresentationValue((LocalDateTime)this.getEmptyValue());
        this.setModelValue((Object)((LocalDateTime)this.getEmptyValue()), clickEvent.isFromClient());
    }

    protected LocalDateTime generateModelValue() {
        if (this.datePicker.isEmpty()) {
            return null;
        }
        if (this.timePicker.isEmpty()) {
            return ((LocalDate)this.datePicker.getValue()).atStartOfDay();
        }
        return ((LocalDate)this.datePicker.getValue()).atTime((LocalTime)this.timePicker.getValue());
    }

    protected void setPresentationValue(LocalDateTime newPresentationValue) {
        if (Objects.equals(this.getEmptyValue(), newPresentationValue)) {
            this.datePicker.clear();
            this.timePicker.clear();
        } else {
            this.datePicker.setValue(newPresentationValue.toLocalDate());
            this.timePicker.setValue(newPresentationValue.toLocalTime());
        }
    }

    public void setStep(Duration step) {
        this.timePicker.setStep(step);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.timePicker.setReadOnly(readOnly);
        this.clearButton.setEnabled(!readOnly && this.isEnabled());
    }
}

