/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.datetimeinterval;

import com.neogls.prism.central.vaadin.common.component.customfield.PrismCustomField;
import com.neogls.prism.central.vaadin.common.component.datetimeinterval.DateTimeRange;
import com.neogls.prism.central.vaadin.common.component.datetimepicker.PrismDateTimePicker;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.time.Duration;
import java.time.LocalDateTime;

public class DateTimeRangePicker
extends PrismCustomField<DateTimeRange> {
    private final PrismDateTimePicker start = new PrismDateTimePicker();
    private final PrismDateTimePicker end = new PrismDateTimePicker();

    public DateTimeRangePicker() {
        super((Object)DateTimeRange.empty());
        this.start.addValueChangeListener(arg_0 -> this.onStartValueChange(arg_0));
        this.end.addValueChangeListener(arg_0 -> this.onEndValueChange(arg_0));
        this.start.addClassName("p-0");
        this.end.addClassName("p-0");
        FlexLayout content = new FlexLayout(new Component[]{this.start, this.end});
        content.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        content.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.add(new Component[]{content});
    }

    private void onStartValueChange(HasValue.ValueChangeEvent<LocalDateTime> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    private void onEndValueChange(HasValue.ValueChangeEvent<LocalDateTime> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    protected DateTimeRange generateModelValue() {
        return new DateTimeRange((LocalDateTime)this.start.getValue(), (LocalDateTime)this.end.getValue());
    }

    protected void setPresentationValue(DateTimeRange newPresentationValue) {
        this.start.setValue((Object)newPresentationValue.getStart());
        this.end.setValue((Object)newPresentationValue.getEnd());
    }

    public void setLabel(String labelStart, String labelEnd) {
        this.start.setLabel(labelStart);
        this.end.setLabel(labelEnd);
    }

    public void setStep(Duration step) {
        this.start.setStep(step);
        this.end.setStep(step);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.start.setReadOnly(readOnly);
        this.end.setReadOnly(readOnly);
    }
}

