/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.dateinterval;

import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import java.time.LocalDate;

public class DateRangePicker
extends CustomField<DateRange> {
    private final DatePicker beginning = new DatePicker();
    private final DatePicker end = new DatePicker();

    public DateRangePicker() {
        super((Object)new DateRange(null, null));
        FlexLayout content = new FlexLayout(new Component[]{this.beginning, new Text("-"), this.end});
        content.setFlexGrow(1.0, new HasElement[]{this.beginning, this.end});
        content.addClassName("gap-xs");
        this.beginning.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.end.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.add(new Component[]{content});
    }

    public DateRangePicker(String label) {
        this();
        this.setLabel(label);
    }

    protected DateRange generateModelValue() {
        return new DateRange((LocalDate)this.beginning.getValue(), (LocalDate)this.end.getValue());
    }

    protected void setPresentationValue(DateRange newPresentationValue) {
        this.beginning.setValue(newPresentationValue.getBeginning());
        this.end.setValue(newPresentationValue.getEnd());
    }

    public void setClearButtonVisible(boolean clearButtonVisible) {
        this.beginning.setClearButtonVisible(clearButtonVisible);
        this.end.setClearButtonVisible(clearButtonVisible);
    }
}

