/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.customfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;

@Tag(value="div")
public abstract class PrismCustomField<T>
extends AbstractField<PrismCustomField<T>, T>
implements HasComponents,
HasLabel,
HasTheme {
    private final Span label = new Span();
    private final Div inputFields = new Div();

    protected PrismCustomField() {
        this(null);
    }

    protected PrismCustomField(T defaultValue) {
        super(defaultValue);
        Div container = new Div(new Component[]{this.label, this.inputFields});
        this.getElement().appendChild(new Element[]{container.getElement()});
        this.label.setClassName("label");
        this.inputFields.setClassName("input-fields");
        container.setClassName("container");
        this.setClassName("prism-custom-field");
    }

    protected abstract T generateModelValue();

    protected void updateValue() {
        this.setModelValue(this.generateModelValue(), true);
    }

    private void addFocusListener(Component ... components) {
        this.addFocusListener(Arrays.asList(components));
    }

    private void addFocusListener(Collection<Component> components) {
        components.forEach(arg_0 -> this.addFocusListener(arg_0));
    }

    private void addFocusListener(Component component) {
        DomListenerRegistration focus = component.getElement().addEventListener("focus", (DomEventListener & Serializable)event -> this.getElement().setAttribute("focused", true));
        DomListenerRegistration blur = component.getElement().addEventListener("blur", (DomEventListener & Serializable)event -> this.getElement().setAttribute("focused", false));
        component.addDetachListener((ComponentEventListener & Serializable)event -> {
            focus.remove();
            blur.remove();
        });
    }

    public void add(Component ... components) {
        this.inputFields.add(components);
        this.addFocusListener(components);
    }

    public void add(Collection<Component> components) {
        this.inputFields.add(components);
        this.addFocusListener(components);
    }

    public void add(String text) {
        this.inputFields.add(text);
    }

    public void remove(Component ... components) {
        this.inputFields.remove(components);
    }

    public void remove(Collection<Component> components) {
        this.inputFields.remove(components);
    }

    public void removeAll() {
        this.inputFields.removeAll();
    }

    public void addComponentAtIndex(int index, Component component) {
        this.inputFields.addComponentAtIndex(index, component);
        this.addFocusListener(component);
    }

    public void addComponentAsFirst(Component component) {
        this.inputFields.addComponentAsFirst(component);
        this.addFocusListener(component);
    }

    public void setLabel(String label) {
        this.label.setText(label);
        this.getElement().setAttribute("has-label", label != null);
    }

    public String getLabel() {
        return this.label.getText();
    }
}

