/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.common.component.confirmdialog;

import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class ConfirmDialog
extends Dialog {
    private ConfirmDialog(String title, String text, @Nullable ButtonConfig confirm, @Nullable ButtonConfig cancel) {
        if (confirm == null && cancel == null) {
            throw new IllegalArgumentException("Either confirm or cancel is required");
        }
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.setHeaderTitle(title);
        this.add(new Component[]{new Text(text)});
        this.createButton(cancel).ifPresent(button -> {
            button.addClassName("mr-auto");
            button.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        });
        this.createButton(confirm);
        this.setWidth(25.0f, Unit.EM);
    }

    private Optional<Button> createButton(@Nullable ButtonConfig config) {
        List buttonVariants;
        if (config == null) {
            return Optional.empty();
        }
        Button button = new Button(config.getText());
        if (config.getListener() != null) {
            button.addClickListener(config.getListener());
        }
        if ((buttonVariants = config.getButtonVariants()) != null && !buttonVariants.isEmpty()) {
            button.addThemeVariants((ThemeVariant[])((ButtonVariant[])buttonVariants.toArray(ButtonVariant[]::new)));
        }
        button.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.getFooter().add(new Component[]{button});
        return Optional.of(button);
    }

    @Generated
    public static ConfirmDialogBuilder builder() {
        return new ConfirmDialogBuilder();
    }
}

